/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.parse.ExplodedRes;
import com.autonomousapps.internal.utils.XmlKt;
import com.autonomousapps.internal.utils.document.DocumentKt;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser;", "", "projectDir", "Ljava/io/File;", "resources", "", "<init>", "(Ljava/io/File;Ljava/lang/Iterable;)V", "androidResSource", "", "Lcom/autonomousapps/internal/parse/ExplodedRes;", "getAndroidResSource", "()Ljava/util/Set;", "extractStyleParentsFromResourceXml", "Lcom/autonomousapps/model/internal/AndroidResSource$StyleParentRef;", "doc", "Lorg/w3c/dom/Document;", "extractAttrsFromResourceXml", "", "container", "Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "extractContentReferencesFromResourceXml", "Container", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nexplodeAndroidResSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n+ 2 document.kt\ncom/autonomousapps/internal/utils/document/DocumentKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n55#2,3:197\n59#2:201\n1#3:200\n108#4:202\n1634#5,3:203\n1869#5,2:206\n1869#5,2:208\n*S KotlinDebug\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n*L\n83#1:197,3\n83#1:201\n83#1:200\n86#1:202\n86#1:203,3\n91#1:206,2\n97#1:208,2\n*E\n"})
public final class AndroidResParser {
    @NotNull
    private final Set<ExplodedRes> androidResSource;

    public AndroidResParser(@NotNull File projectDir, @NotNull Iterable<? extends File> resources) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.androidResSource = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence(resources), AndroidResParser::androidResSource$lambda$0), arg_0 -> AndroidResParser.androidResSource$lambda$1(this, projectDir, arg_0)));
    }

    @NotNull
    public final Set<ExplodedRes> getAndroidResSource() {
        return this.androidResSource;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AndroidResSource.StyleParentRef> extractStyleParentsFromResourceXml(Document doc) {
        void $this$mapTo$iv$iv;
        String it$iv;
        NodeList nodeList = doc.getElementsByTagName("style");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        NodeList $this$mapNotNull$iv = nodeList;
        boolean $i$f$mapNotNull = false;
        Iterable<String> destination$iv = new ArrayList($this$mapNotNull$iv.getLength());
        int n = $this$mapNotNull$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Node it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapNotNull$iv.item(i$iv), (String)"item(...)");
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem("parent");
            if ((node != null ? node.getNodeValue() : null) == null) continue;
            it$iv = it$iv;
            boolean bl2 = false;
            ((ArrayList)destination$iv).add(it$iv);
        }
        Iterable $this$mapToSet$iv = (List)destination$iv;
        boolean $i$f$mapToSet = false;
        destination$iv = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(com.autonomousapps.internal.utils.CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            it$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AndroidResSource.StyleParentRef.Companion.of((String)it));
        }
        return (Set)destination$iv$iv;
    }

    private final void extractAttrsFromResourceXml(Document doc, Container container) {
        Iterable $this$forEach$iv = DocumentKt.attrs(doc);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)it, container);
        }
    }

    private final void extractContentReferencesFromResourceXml(Document doc, Container container) {
        Iterable $this$forEach$iv = DocumentKt.contentReferences(doc).entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)TuplesKt.to(it.getKey(), it.getValue()), container);
        }
    }

    private static final Pair androidResSource$lambda$0(File it) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            pair = TuplesKt.to((Object)it, (Object)XmlKt.buildDocument(it));
        }
        catch (SAXParseException sAXParseException) {
            pair = null;
        }
        return pair;
    }

    private static final ExplodedRes androidResSource$lambda$1(AndroidResParser this$0, File $projectDir, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        File file = (File)pair.component1();
        Document doc = (Document)pair.component2();
        Container container = new Container();
        this$0.extractAttrsFromResourceXml(doc, container);
        this$0.extractContentReferencesFromResourceXml(doc, container);
        return new ExplodedRes(FilesKt.toRelativeString((File)file, (File)$projectDir), this$0.extractStyleParentsFromResourceXml(doc), container.nonLocalAttrRefs());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "", "<init>", "()V", "attrRefs", "", "Lcom/autonomousapps/model/internal/AndroidResSource$AttrRef;", "getAttrRefs", "()Ljava/util/Set;", "newIds", "getNewIds", "nonLocalAttrRefs", "", "dependency-analysis-gradle-plugin"})
    public static final class Container {
        @NotNull
        private final Set<AndroidResSource.AttrRef> attrRefs = new LinkedHashSet();
        @NotNull
        private final Set<AndroidResSource.AttrRef> newIds = new LinkedHashSet();

        @NotNull
        public final Set<AndroidResSource.AttrRef> getAttrRefs() {
            return this.attrRefs;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> getNewIds() {
            return this.newIds;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> nonLocalAttrRefs() {
            return SetsKt.minus(this.attrRefs, (Iterable)this.newIds);
        }
    }
}

