/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model.source;

import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.source.JvmSourceKind;
import com.autonomousapps.model.source.SourceKind;
import com.squareup.moshi.JsonClass;
import dev.zacsweers.moshix.sealed.annotations.TypeLabel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TypeLabel(label="android")
@JsonClass(generateAdapter=false)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000f\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0018J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0096\u0002J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J1\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u001aH\u00d6\u0001J\t\u0010$\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/autonomousapps/model/source/AndroidSourceKind;", "Lcom/autonomousapps/model/source/SourceKind;", "Ljava/io/Serializable;", "name", "", "kind", "compileClasspathName", "runtimeClasspathName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getKind", "getCompileClasspathName", "getRuntimeClasspathName", "base", "base$dependency_analysis_gradle_plugin", "runtimeMatches", "", "classpaths", "", "runtimeMatches$dependency_analysis_gradle_plugin", "sourceSetMatches", "sourceSetName", "sourceSetMatches$dependency_analysis_gradle_plugin", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSourceKind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceKind.kt\ncom/autonomousapps/model/source/AndroidSourceKind\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n827#2:263\n855#2,2:264\n1563#2:266\n1634#2,3:267\n1761#2,3:270\n*S KotlinDebug\n*F\n+ 1 SourceKind.kt\ncom/autonomousapps/model/source/AndroidSourceKind\n*L\n87#1:263\n87#1:264,2\n88#1:266\n88#1:267,3\n90#1:270,3\n*E\n"})
public final class AndroidSourceKind
extends SourceKind
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String kind;
    @NotNull
    private final String compileClasspathName;
    @NotNull
    private final String runtimeClasspathName;
    @NotNull
    private static final AndroidSourceKind MAIN = Companion.main("main");
    @NotNull
    private static final AndroidSourceKind TEST = Companion.test("test");
    @NotNull
    private static final AndroidSourceKind ANDROID_TEST = Companion.androidTest("androidTest");
    @NotNull
    private static final AndroidSourceKind ANDROID_TEST_FIXTURES = Companion.testFixtures("testFixtures");
    @NotNull
    private static final List<String> VIRTUAL_CLASSPATHS;

    public AndroidSourceKind(@NotNull String name, @NotNull String kind, @NotNull String compileClasspathName, @NotNull String runtimeClasspathName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)compileClasspathName, (String)"compileClasspathName");
        Intrinsics.checkNotNullParameter((Object)runtimeClasspathName, (String)"runtimeClasspathName");
        super(null);
        this.name = name;
        this.kind = kind;
        this.compileClasspathName = compileClasspathName;
        this.runtimeClasspathName = runtimeClasspathName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public String getCompileClasspathName() {
        return this.compileClasspathName;
    }

    @Override
    @NotNull
    public String getRuntimeClasspathName() {
        return this.runtimeClasspathName;
    }

    @Override
    @NotNull
    public AndroidSourceKind base$dependency_analysis_gradle_plugin() {
        AndroidSourceKind androidSourceKind;
        switch (this.getKind()) {
            case "MAIN": {
                androidSourceKind = Companion.main("main");
                break;
            }
            case "TEST": {
                androidSourceKind = Companion.test("test");
                break;
            }
            case "ANDROID_TEST_FIXTURES": {
                androidSourceKind = Companion.testFixtures("testFixtures");
                break;
            }
            case "ANDROID_TEST": {
                androidSourceKind = Companion.androidTest("androidTest");
                break;
            }
            default: {
                throw new IllegalStateException(("Expected one of 'main', 'test', or 'androidTest'. Was '" + this.getKind() + "'.").toString());
            }
        }
        return androidSourceKind;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean runtimeMatches$dependency_analysis_gradle_plugin(@NotNull Collection<String> classpaths) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(classpaths, (String)"classpaths");
            if (VIRTUAL_CLASSPATHS.contains(this.getRuntimeClasspathName())) {
                void $this$mapTo$iv$iv;
                String it;
                Iterable $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = classpaths;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (StringsKt.endsWith$default((String)it, (String)"CompileClasspath", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(StringsKt.removeSuffix((String)it, (CharSequence)"RuntimeClasspath"));
                }
                List variants = (List)destination$iv$iv;
                Iterable $this$any$iv = variants;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String m = (String)element$iv;
                        boolean bl4 = false;
                        boolean bl5 = StringsKt.endsWith$default((String)m, (String)"UnitTest", (boolean)false, (int)2, null) ? Intrinsics.areEqual((Object)this.getKind(), (Object)"TEST") : (StringsKt.endsWith$default((String)m, (String)"AndroidTest", (boolean)false, (int)2, null) ? Intrinsics.areEqual((Object)this.getKind(), (Object)"ANDROID_TEST") : (StringsKt.endsWith$default((String)m, (String)"TestFixtures", (boolean)false, (int)2, null) ? Intrinsics.areEqual((Object)this.getKind(), (Object)"ANDROID_TEST_FIXTURES") : Intrinsics.areEqual((Object)this.getKind(), (Object)"MAIN") || Intrinsics.areEqual((Object)this.getKind(), (Object)"ANDROID_TEST")));
                        if (!bl5) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = classpaths.contains(this.getRuntimeClasspathName());
            }
        }
        return bl;
    }

    @Override
    public boolean sourceSetMatches$dependency_analysis_gradle_plugin(@NotNull String sourceSetName) {
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        return Intrinsics.areEqual((Object)sourceSetName, (Object)this.getName()) || Intrinsics.areEqual((Object)sourceSetName, (Object)this.base$dependency_analysis_gradle_plugin().getName()) || Intrinsics.areEqual((Object)sourceSetName, (Object)(this.getName() + UtilsKt.capitalizeSafely(this.base$dependency_analysis_gradle_plugin().getName())));
    }

    @Override
    public int compareTo(@NotNull SourceKind other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof JvmSourceKind) {
            return -1;
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                SourceKind p0 = (SourceKind)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getName());
                p0 = (SourceKind)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    SourceKind p0 = (SourceKind)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getKind());
                    p0 = (SourceKind)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getKind())));
                }
                return n;
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    SourceKind p0 = (SourceKind)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getCompileClasspathName());
                    p0 = (SourceKind)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getCompileClasspathName())));
                }
                return n;
            }
        };
        return ((Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    SourceKind p0 = (SourceKind)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getRuntimeClasspathName());
                    p0 = (SourceKind)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getRuntimeClasspathName())));
                }
                return n;
            }
        }).compare(this, other);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.kind;
    }

    @NotNull
    public final String component3() {
        return this.compileClasspathName;
    }

    @NotNull
    public final String component4() {
        return this.runtimeClasspathName;
    }

    @NotNull
    public final AndroidSourceKind copy(@NotNull String name, @NotNull String kind, @NotNull String compileClasspathName, @NotNull String runtimeClasspathName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)compileClasspathName, (String)"compileClasspathName");
        Intrinsics.checkNotNullParameter((Object)runtimeClasspathName, (String)"runtimeClasspathName");
        return new AndroidSourceKind(name, kind, compileClasspathName, runtimeClasspathName);
    }

    public static /* synthetic */ AndroidSourceKind copy$default(AndroidSourceKind androidSourceKind, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = androidSourceKind.name;
        }
        if ((n & 2) != 0) {
            string2 = androidSourceKind.kind;
        }
        if ((n & 4) != 0) {
            string3 = androidSourceKind.compileClasspathName;
        }
        if ((n & 8) != 0) {
            string4 = androidSourceKind.runtimeClasspathName;
        }
        return androidSourceKind.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "AndroidSourceKind(name=" + this.name + ", kind=" + this.kind + ", compileClasspathName=" + this.compileClasspathName + ", runtimeClasspathName=" + this.runtimeClasspathName + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.kind.hashCode();
        result = result * 31 + this.compileClasspathName.hashCode();
        result = result * 31 + this.runtimeClasspathName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AndroidSourceKind)) {
            return false;
        }
        AndroidSourceKind androidSourceKind = (AndroidSourceKind)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)androidSourceKind.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kind, (Object)androidSourceKind.kind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.compileClasspathName, (Object)androidSourceKind.compileClasspathName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runtimeClasspathName, (Object)androidSourceKind.runtimeClasspathName);
    }

    static {
        Object[] objectArray = new String[]{"runtimeClasspath", "unitTestRuntimeClasspath", "androidTestRuntimeClasspath", "testFixturesRuntimeClasspath"};
        VIRTUAL_CLASSPATHS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/model/source/AndroidSourceKind$Companion;", "", "<init>", "()V", "MAIN", "Lcom/autonomousapps/model/source/AndroidSourceKind;", "getMAIN", "()Lcom/autonomousapps/model/source/AndroidSourceKind;", "TEST", "getTEST", "ANDROID_TEST", "getANDROID_TEST", "ANDROID_TEST_FIXTURES", "getANDROID_TEST_FIXTURES", "VIRTUAL_CLASSPATHS", "", "", "getVIRTUAL_CLASSPATHS", "()Ljava/util/List;", "main", "variantName", "test", "testFixtures", "androidTest", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AndroidSourceKind getMAIN() {
            return MAIN;
        }

        @NotNull
        public final AndroidSourceKind getTEST() {
            return TEST;
        }

        @NotNull
        public final AndroidSourceKind getANDROID_TEST() {
            return ANDROID_TEST;
        }

        @NotNull
        public final AndroidSourceKind getANDROID_TEST_FIXTURES() {
            return ANDROID_TEST_FIXTURES;
        }

        @NotNull
        public final List<String> getVIRTUAL_CLASSPATHS() {
            return VIRTUAL_CLASSPATHS;
        }

        @NotNull
        public final AndroidSourceKind main(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return new AndroidSourceKind(variantName, "MAIN", (String)(Intrinsics.areEqual((Object)variantName, (Object)"main") ? "compileClasspath" : variantName + "CompileClasspath"), (String)(Intrinsics.areEqual((Object)variantName, (Object)"main") ? "runtimeClasspath" : variantName + "RuntimeClasspath"));
        }

        @NotNull
        public final AndroidSourceKind test(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return new AndroidSourceKind(variantName, "TEST", (String)(Intrinsics.areEqual((Object)variantName, (Object)"test") ? "unitTestCompileClasspath" : variantName + "UnitTestCompileClasspath"), (String)(Intrinsics.areEqual((Object)variantName, (Object)"test") ? "unitTestRuntimeClasspath" : variantName + "UnitTestRuntimeClasspath"));
        }

        @NotNull
        public final AndroidSourceKind testFixtures(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return new AndroidSourceKind(variantName, "ANDROID_TEST_FIXTURES", (String)(Intrinsics.areEqual((Object)variantName, (Object)"testFixtures") ? "testFixturesCompileClasspath" : variantName + "TestFixturesCompileClasspath"), (String)(Intrinsics.areEqual((Object)variantName, (Object)"testFixtures") ? "testFixturesRuntimeClasspath" : variantName + "TestFixturesRuntimeClasspath"));
        }

        @NotNull
        public final AndroidSourceKind androidTest(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return new AndroidSourceKind(variantName, "ANDROID_TEST", (String)(Intrinsics.areEqual((Object)variantName, (Object)"androidTest") ? "androidTestCompileClasspath" : variantName + "AndroidTestCompileClasspath"), (String)(Intrinsics.areEqual((Object)variantName, (Object)"androidTest") ? "androidTestRuntimeClasspath" : variantName + "AndroidTestRuntimeClasspath"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

