/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.exception.BuildHealthException;
import com.autonomousapps.internal.utils.Colors;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.BuildHealth;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Always prints output")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0012H\u0002J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/tasks/BuildHealthTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "shouldFail", "Lorg/gradle/api/file/RegularFileProperty;", "getShouldFail", "()Lorg/gradle/api/file/RegularFileProperty;", "buildHealth", "getBuildHealth", "consoleReport", "getConsoleReport", "printBuildHealth", "Lorg/gradle/api/provider/Property;", "", "getPrintBuildHealth", "()Lorg/gradle/api/provider/Property;", "postscript", "", "getPostscript", "action", "", "bold", "error", "warning", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBuildHealthTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHealthTask.kt\ncom/autonomousapps/tasks/BuildHealthTask\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n142#2,13:94\n41#3,2:107\n34#3,4:109\n1#4:113\n*S KotlinDebug\n*F\n+ 1 BuildHealthTask.kt\ncom/autonomousapps/tasks/BuildHealthTask\n*L\n48#1:94,13\n48#1:107,2\n48#1:109,4\n*E\n"})
public abstract class BuildHealthTask
extends DefaultTask {
    public BuildHealthTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates holistic advice for whole project, and can fail the build if desired");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getShouldFail();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildHealth();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getConsoleReport();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintBuildHealth();

    @Input
    @NotNull
    public abstract Property<String> getPostscript();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Object object;
        File file = ((RegularFile)this.getShouldFail().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        boolean shouldFail = Boolean.parseBoolean(FilesKt.readText$default((File)file, null, (int)1, null));
        File consoleReportFile = ((RegularFile)this.getConsoleReport().get()).getAsFile();
        Path consoleReportPath = consoleReportFile.toPath();
        RegularFileProperty $this$fromJson$iv = this.getBuildHealth();
        boolean $i$f$fromJson = false;
        Object object2 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
        boolean $i$f$fromJson2 = false;
        File file2 = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        File $this$fromJson$iv$iv$iv = file2;
        boolean $i$f$fromJson3 = false;
        Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv$iv$iv;
            BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(BuildHealth.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            boolean withNulls$iv$iv$iv$iv$iv = withNulls$iv$iv$iv$iv;
            boolean $i$f$withNulls = false;
            Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        boolean isWarningOnly = ((BuildHealth)object).isEmptyOrWarningOnly();
        boolean hasText = consoleReportFile.length() > 0L;
        Boolean printBuildHealth = (Boolean)this.getPrintBuildHealth().get();
        StringBuilder $this$action_u24lambda_u240 = $i$f$fromJson2 = new StringBuilder();
        boolean bl = false;
        if (printBuildHealth.booleanValue()) {
            Intrinsics.checkNotNull((Object)consoleReportFile);
            $this$action_u24lambda_u240.append(FilesKt.readText$default((File)consoleReportFile, null, (int)1, null));
        } else {
            String ps = (String)this.getPostscript().get();
            Intrinsics.checkNotNull((Object)ps);
            if (((CharSequence)ps).length() > 0) {
                $this$action_u24lambda_u240.append(this.bold(ps));
            }
        }
        $this$action_u24lambda_u240.append('\n');
        $this$action_u24lambda_u240.append('\n');
        StringBuilder stringBuilder = isWarningOnly ? $this$action_u24lambda_u240.append(this.warning("There were non-fatal dependency warnings.")).append('\n') : (!shouldFail ? $this$action_u24lambda_u240.append(this.warning("There were non-fatal dependency violations.")).append('\n') : $this$action_u24lambda_u240.append(this.error("There were fatal dependency violations.")).append('\n'));
        $this$action_u24lambda_u240.append("See report at " + consoleReportPath.toUri() + " ");
        String output = $i$f$fromJson2.toString();
        if (shouldFail) {
            if (!hasText) {
                boolean bl2 = false;
                String string = "Console report should not be blank if buildHealth should fail";
                throw new IllegalStateException(string.toString());
            }
            throw new BuildHealthException(output);
        }
        if (hasText) {
            this.getLogger().quiet(output);
        }
    }

    private final String bold(String $this$bold) {
        return Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin($this$bold, "\u001b[1m");
    }

    private final String error(String $this$error) {
        return Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin($this$error, "\u001b[1;31m");
    }

    private final String warning(String $this$warning) {
        return Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin($this$warning, "\u001b[1;33m");
    }
}

