/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.producer.AndroidAssetDependency;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/FindAndroidAssetProviders;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "assetDirs", "Lorg/gradle/api/artifacts/ArtifactCollection;", "setAssets", "", "assets", "getAssetArtifactFiles", "Lorg/gradle/api/file/FileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFindAndroidAssetProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindAndroidAssetProviders.kt\ncom/autonomousapps/tasks/FindAndroidAssetProviders\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n154#2,13:65\n50#2,3:78\n34#2,4:81\n167#2,2:85\n11228#3:87\n11563#3,3:88\n*S KotlinDebug\n*F\n+ 1 FindAndroidAssetProviders.kt\ncom/autonomousapps/tasks/FindAndroidAssetProviders\n*L\n61#1:65,13\n61#1:78,3\n61#1:81,4\n61#1:85,2\n48#1:87\n48#1:88,3\n*E\n"})
public abstract class FindAndroidAssetProviders
extends DefaultTask {
    private ArtifactCollection assetDirs;

    public FindAndroidAssetProviders() {
        this.setDescription("Produces a report of dependencies that supply Android assets");
    }

    public final void setAssets(@NotNull ArtifactCollection assets) {
        Intrinsics.checkNotNullParameter((Object)assets, (String)"assets");
        this.assetDirs = assets;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final FileCollection getAssetArtifactFiles() {
        ArtifactCollection artifactCollection = this.assetDirs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetDirs");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getArtifactFiles(...)");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJsonSet_u24default$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ArtifactCollection artifactCollection = this.assetDirs;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetDirs");
            artifactCollection = null;
        }
        Set assetProviders = SequencesKt.toSortedSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)artifactCollection)), FindAndroidAssetProviders::action$lambda$0), FindAndroidAssetProviders::action$lambda$1), FindAndroidAssetProviders::action$lambda$2), FindAndroidAssetProviders::action$lambda$4));
        File file = outputFile;
        Set set$iv = assetProviders;
        boolean compress$iv = false;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        BufferedSink buffer$iv = Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null));
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)buffer$iv);
        Throwable throwable = null;
        try {
            void $this$withNulls$iv$iv$iv;
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            Type[] typeArray = new Type[]{AndroidAssetDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"adapter(...)");
            typeArray = typeArray2;
            boolean withNulls$iv$iv$iv = withNulls$iv$iv;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)set$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final boolean action$lambda$0(ResolvedArtifactResult it) {
        return it.getFile().exists();
    }

    private static final boolean action$lambda$1(ResolvedArtifactResult it) {
        return it.getFile().isDirectory();
    }

    private static final boolean action$lambda$2(ResolvedArtifactResult it) {
        File[] fileArray = it.getFile().listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        return !(fileArray.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final AndroidAssetDependency action$lambda$4(ResolvedArtifactResult artifact) {
        AndroidAssetDependency androidAssetDependency;
        try {
            void $this$mapTo$iv$iv;
            File dir = artifact.getFile();
            File[] fileArray = dir.listFiles();
            Intrinsics.checkNotNull((Object)fileArray);
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Intrinsics.checkNotNull((Object)dir);
                collection.add(FilesKt.toRelativeString((File)it, (File)dir));
            }
            List assets = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)artifact);
            androidAssetDependency = AndroidAssetDependency.Companion.newInstance(GradleStringsKt.toCoordinates(artifact), assets);
        }
        catch (GradleException gradleException) {
            androidAssetDependency = null;
        }
        return androidAssetDependency;
    }
}

