/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.Topological;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001d\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR4\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000fj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0015*\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lcom/autonomousapps/graph/DominanceTree;", "N", "", "backingGraph", "Lcom/google/common/graph/Graph;", "root", "<init>", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "Ljava/lang/Object;", "backingNodes", "", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "doms", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "top", "", "nodeNumberMap", "", "", "nodeNumber", "getNodeNumber", "(Ljava/lang/Object;)I", "computeDominance", "", "intersect", "n1", "n2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "dominanceGraph", "getDominanceGraph", "()Lcom/google/common/graph/Graph;", "dominanceGraph$delegate", "Lkotlin/Lazy;", "graph-support"})
@SourceDebugExtension(value={"SMAP\nDominanceTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DominanceTree.kt\ncom/autonomousapps/graph/DominanceTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1863#2,2:128\n1567#2:130\n1598#2,4:131\n1863#2,2:136\n1863#2,2:152\n1317#3:135\n1318#3:138\n136#4,9:139\n216#4:148\n217#4:150\n145#4:151\n1#5:149\n*S KotlinDebug\n*F\n+ 1 DominanceTree.kt\ncom/autonomousapps/graph/DominanceTree\n*L\n26#1:128,2\n37#1:130\n37#1:131,4\n57#1:136,2\n91#1:152,2\n52#1:135\n52#1:138\n89#1:139,9\n89#1:148\n89#1:150\n89#1:151\n89#1:149\n*E\n"})
public final class DominanceTree<N> {
    @NotNull
    private final Graph<N> backingGraph;
    @NotNull
    private final N root;
    private final Set<N> backingNodes;
    @NotNull
    private final HashMap<N, N> doms;
    @NotNull
    private final List<N> top;
    @NotNull
    private final Map<N, Integer> nodeNumberMap;
    @NotNull
    private final Lazy dominanceGraph$delegate;

    /*
     * WARNING - void declaration
     */
    public DominanceTree(@NotNull Graph<N> backingGraph, @NotNull N root) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(backingGraph, (String)"backingGraph");
        Intrinsics.checkNotNullParameter(root, (String)"root");
        this.backingGraph = backingGraph;
        this.root = root;
        this.backingNodes = this.backingGraph.nodes();
        Object object = new HashMap(this.backingNodes.size());
        HashMap hashMap = object;
        DominanceTree dominanceTree = this;
        boolean $i$a$-apply-DominanceTree$doms$22 = false;
        Set<N> set = this.backingNodes;
        Intrinsics.checkNotNullExpressionValue(set, (String)"backingNodes");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$doms_u24lambda_u241;
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            $this$doms_u24lambda_u241.put(it, it);
        }
        dominanceTree.doms = object;
        this.top = CollectionsKt.toList(new Topological<N>(this.backingGraph, this.root).getOrder());
        object = this.top;
        dominanceTree = this;
        boolean $i$f$mapIndexed = false;
        void $i$a$-apply-DominanceTree$doms$22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void n;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)n, (Object)(this.top.size() - i)));
        }
        dominanceTree.nodeNumberMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.computeDominance();
        this.dominanceGraph$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> DominanceTree.dominanceGraph_delegate$lambda$8(this));
    }

    private final int getNodeNumber(N $this$nodeNumber) {
        Integer n = this.nodeNumberMap.get($this$nodeNumber);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    private final void computeDominance() {
        boolean changed = false;
        changed = true;
        while (changed) {
            changed = false;
            Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.top), arg_0 -> DominanceTree.computeDominance$lambda$3(this, arg_0));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object n = element$iv = iterator.next();
                boolean bl = false;
                Set predecessors = this.backingGraph.predecessors(n);
                Object newIDom = null;
                Intrinsics.checkNotNull((Object)predecessors);
                newIDom = CollectionsKt.first((Iterable)predecessors);
                Iterable $this$forEach$iv2 = SetsKt.minus((Set)predecessors, (Object)newIDom);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2;
                    Object p = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(this.doms.get(p), p)) continue;
                    Intrinsics.checkNotNull(p);
                    Object object = newIDom;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
                    newIDom = this.intersect(p, object);
                }
                if (Intrinsics.areEqual(this.doms.get(n), (Object)newIDom)) continue;
                ((Map)this.doms).put(n, newIDom);
                changed = true;
            }
        }
    }

    private final N intersect(N n1, N n2) {
        N left = n1;
        N right = n2;
        while (this.getNodeNumber(left) != this.getNodeNumber(right)) {
            while (this.getNodeNumber(left) < this.getNodeNumber(right)) {
                Intrinsics.checkNotNull(this.doms.get(left));
            }
            while (this.getNodeNumber(right) < this.getNodeNumber(left)) {
                Intrinsics.checkNotNull(this.doms.get(right));
            }
        }
        return left;
    }

    @NotNull
    public final Graph<N> getDominanceGraph() {
        Lazy lazy = this.dominanceGraph$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Graph)object;
    }

    private static final boolean computeDominance$lambda$3(DominanceTree this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, this$0.root);
    }

    /*
     * WARNING - void declaration
     */
    private static final ImmutableGraph dominanceGraph_delegate$lambda$8(DominanceTree this$0) {
        void $this$mapNotNullTo$iv$iv;
        ImmutableGraph.Builder builder = GraphBuilder.directed().allowsSelfLoops(false).incidentEdgeOrder(ElementOrder.stable()).immutable();
        Map $this$mapNotNull$iv = this$0.doms;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object dom;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Object sub = entry.getKey();
            if ((!Intrinsics.areEqual(sub, dom = entry.getValue()) ? TuplesKt.to(dom, sub) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            builder.putEdge(it.getFirst(), it.getSecond());
        }
        return builder.build();
    }
}

