/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.Topological;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00172\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dR\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\r\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\nj\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/autonomousapps/graph/ShortestPath;", "N", "", "graph", "Lcom/google/common/graph/Graph;", "source", "<init>", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "Ljava/lang/Object;", "distTo", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "edgeTo", "Lcom/google/common/graph/EndpointPair;", "distanceTo", "", "other", "(Ljava/lang/Object;)Ljava/lang/Integer;", "hasPathTo", "", "(Ljava/lang/Object;)Z", "pathTo", "", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "edgesTo", "relax", "", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "graph-support"})
@SourceDebugExtension(value={"SMAP\nShortestPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortestPath.kt\ncom/autonomousapps/graph/ShortestPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1628#2,3:73\n*S KotlinDebug\n*F\n+ 1 ShortestPath.kt\ncom/autonomousapps/graph/ShortestPath\n*L\n48#1:73,3\n*E\n"})
public final class ShortestPath<N> {
    @NotNull
    private final N source;
    @NotNull
    private final LinkedHashMap<N, Float> distTo;
    @NotNull
    private final LinkedHashMap<N, EndpointPair<N>> edgeTo;

    public ShortestPath(@NotNull Graph<N> graph, @NotNull N source) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
        this.distTo = new LinkedHashMap();
        this.edgeTo = new LinkedHashMap();
        for (Object node : graph.nodes()) {
            ((Map)this.distTo).put(node, Float.valueOf(Float.POSITIVE_INFINITY));
        }
        ((Map)this.distTo).put(this.source, Float.valueOf(0.0f));
        Topological<N> top = new Topological<N>(graph, this.source);
        for (N from : top.getOrder()) {
            for (Object to : graph.successors(from)) {
                Intrinsics.checkNotNull(to);
                this.relax(from, to);
            }
        }
    }

    @Nullable
    public final Integer distanceTo(@NotNull N other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Float f = this.distTo.get(other);
        return f != null ? Integer.valueOf((int)f.floatValue()) : null;
    }

    public final boolean hasPathTo(@NotNull N other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Float f = this.distTo.get(other);
        if (f == null) {
            return false;
        }
        float dist = f.floatValue();
        return dist < Float.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<N> pathTo(@NotNull N other) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (!this.hasPathTo(other)) {
            return CollectionsKt.emptyList();
        }
        Iterable<EndpointPair<N>> iterable = this.edgesTo(other);
        Object[] objectArray = new Object[]{this.source};
        Collection destination$iv = CollectionsKt.mutableListOf((Object[])objectArray);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            EndpointPair endpointPair = (EndpointPair)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.target());
        }
        return (Iterable)objectArray;
    }

    private final Iterable<EndpointPair<N>> edgesTo(N other) {
        if (!this.hasPathTo(other)) {
            return CollectionsKt.emptyList();
        }
        ArrayDeque<EndpointPair<N>> path = new ArrayDeque<EndpointPair<N>>();
        EndpointPair<N> e = this.edgeTo.get(other);
        while (e != null) {
            path.push(e);
            e = this.edgeTo.get(e.source());
        }
        return path;
    }

    private final void relax(N source, N target) {
        Float f = this.distTo.get(target);
        Intrinsics.checkNotNull((Object)f);
        float f2 = ((Number)f).floatValue();
        Float f3 = this.distTo.get(source);
        Intrinsics.checkNotNull((Object)f3);
        if (f2 > ((Number)f3).floatValue() + 1.0f) {
            Map map = this.distTo;
            Float f4 = this.distTo.get(source);
            Intrinsics.checkNotNull((Object)f4);
            map.put(target, Float.valueOf(((Number)f4).floatValue() + 1.0f));
            ((Map)this.edgeTo).put(target, EndpointPair.ordered(source, target));
        }
    }
}

