/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.Graphs;
import com.autonomousapps.graph.Topological;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001d\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u000e\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0010j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0016*\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R!\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010\n\u00a8\u0006&"}, d2={"Lcom/autonomousapps/graph/DominanceTree;", "N", "", "backingGraph", "Lcom/google/common/graph/Graph;", "root", "<init>", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "(Lcom/google/common/graph/Graph;)V", "getBackingGraph", "()Lcom/google/common/graph/Graph;", "getRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "undefined", "doms", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "top", "", "nodeNumberMap", "", "", "nodeNumber", "getNodeNumber", "(Ljava/lang/Object;)I", "computeDominance", "", "intersect", "predecessor", "newIDom", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "selfDominatingNodes", "", "dominanceGraph", "getDominanceGraph", "dominanceGraph$delegate", "Lkotlin/Lazy;", "graph-support"})
@SourceDebugExtension(value={"SMAP\nDominanceTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DominanceTree.kt\ncom/autonomousapps/graph/DominanceTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1567#2:139\n1598#2,4:140\n295#2,2:145\n1863#2,2:147\n1863#2,2:170\n1317#3:144\n1318#3:149\n535#4:150\n520#4,6:151\n136#5,9:157\n216#5:166\n217#5:168\n145#5:169\n1#6:167\n*S KotlinDebug\n*F\n+ 1 DominanceTree.kt\ncom/autonomousapps/graph/DominanceTree\n*L\n39#1:139\n39#1:140,4\n57#1:145,2\n60#1:147,2\n102#1:170,2\n54#1:144\n54#1:149\n90#1:150\n90#1:151,6\n100#1:157,9\n100#1:166\n100#1:168\n100#1:169\n100#1:167\n*E\n"})
public final class DominanceTree<N> {
    @NotNull
    private final Graph<N> backingGraph;
    @NotNull
    private final N root;
    @Nullable
    private final N undefined;
    @NotNull
    private final HashMap<N, N> doms;
    @NotNull
    private final List<N> top;
    @NotNull
    private final Map<N, Integer> nodeNumberMap;
    @NotNull
    private final Lazy dominanceGraph$delegate;

    /*
     * WARNING - void declaration
     */
    public DominanceTree(@NotNull Graph<N> backingGraph, @NotNull N root) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        void $this$doms_u24lambda_u240;
        Intrinsics.checkNotNullParameter(backingGraph, (String)"backingGraph");
        Intrinsics.checkNotNullParameter(root, (String)"root");
        this.backingGraph = backingGraph;
        this.root = root;
        Object object = new HashMap(this.backingGraph.nodes().size());
        HashMap hashMap = object;
        DominanceTree dominanceTree = this;
        boolean $i$a$-apply-DominanceTree$doms$22 = false;
        $this$doms_u24lambda_u240.put(this.root, this.root);
        dominanceTree.doms = object;
        this.top = CollectionsKt.toList(new Topological<N>(this.backingGraph, this.root).getOrder());
        object = this.top;
        dominanceTree = this;
        boolean $i$f$mapIndexed = false;
        void $i$a$-apply-DominanceTree$doms$22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void n;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)n, (Object)(this.top.size() - i)));
        }
        dominanceTree.nodeNumberMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.computeDominance();
        this.dominanceGraph$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> DominanceTree.dominanceGraph_delegate$lambda$9(this));
    }

    @NotNull
    public final Graph<N> getBackingGraph() {
        return this.backingGraph;
    }

    @NotNull
    public final N getRoot() {
        return this.root;
    }

    public DominanceTree(@NotNull Graph<N> backingGraph) {
        Intrinsics.checkNotNullParameter(backingGraph, (String)"backingGraph");
        this(backingGraph, Graphs.INSTANCE.root(backingGraph));
    }

    private final int getNodeNumber(N $this$nodeNumber) {
        Integer n = this.nodeNumberMap.get($this$nodeNumber);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void computeDominance() {
        boolean changed = false;
        changed = true;
        while (changed) {
            changed = false;
            Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.top), arg_0 -> DominanceTree.computeDominance$lambda$2(this, arg_0));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Iterator iterator2;
                Ref.ObjectRef newIDom;
                Set predecessors;
                Object n;
                block4: {
                    Object object;
                    void $this$firstOrNull$iv;
                    Object element$iv2;
                    n = element$iv2 = iterator.next();
                    boolean bl = false;
                    predecessors = this.backingGraph.predecessors(n);
                    newIDom = new Ref.ObjectRef();
                    Intrinsics.checkNotNull((Object)predecessors);
                    Iterable iterable = predecessors;
                    Ref.ObjectRef objectRef = newIDom;
                    boolean $i$f$firstOrNull = false;
                    iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(this.doms.get(it), this.undefined))) continue;
                        object = element$iv;
                        break block4;
                    }
                    object = objectRef.element = null;
                }
                if (newIDom.element == null) continue;
                Iterable $this$forEach$iv2 = SetsKt.minus((Set)predecessors, (Object)newIDom.element);
                boolean $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object p = element$iv = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual(this.doms.get(p), this.undefined)) continue;
                    Intrinsics.checkNotNull(p);
                    Object object = newIDom.element;
                    Intrinsics.checkNotNull((Object)object);
                    newIDom.element = this.intersect(p, object);
                }
                if (Intrinsics.areEqual(this.doms.get(n), (Object)newIDom.element)) continue;
                Map map = this.doms;
                Object object = newIDom.element;
                Intrinsics.checkNotNull((Object)object);
                map.put(n, object);
                changed = true;
            }
        }
    }

    private final N intersect(N predecessor, N newIDom) {
        N left = predecessor;
        N right = newIDom;
        while (this.getNodeNumber(left) != this.getNodeNumber(right)) {
            while (this.getNodeNumber(left) < this.getNodeNumber(right)) {
                Intrinsics.checkNotNull(this.doms.get(left));
            }
            while (this.getNodeNumber(right) < this.getNodeNumber(left)) {
                Intrinsics.checkNotNull(this.doms.get(right));
            }
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<N> selfDominatingNodes() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.doms;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getKey(), it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.keySet();
    }

    @NotNull
    public final Graph<N> getDominanceGraph() {
        Lazy lazy = this.dominanceGraph$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Graph)object;
    }

    private static final boolean computeDominance$lambda$2(DominanceTree this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, this$0.root);
    }

    /*
     * WARNING - void declaration
     */
    private static final ImmutableGraph dominanceGraph_delegate$lambda$9(DominanceTree this$0) {
        void $this$mapNotNullTo$iv$iv;
        ImmutableGraph.Builder builder = GraphBuilder.directed().allowsSelfLoops(false).incidentEdgeOrder(ElementOrder.stable()).immutable();
        Map $this$mapNotNull$iv = this$0.doms;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object dom;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Object sub = entry.getKey();
            if ((!Intrinsics.areEqual(sub, dom = entry.getValue()) ? TuplesKt.to(dom, sub) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            builder.putEdge(it.getFirst(), it.getSecond());
        }
        return builder.build();
    }
}

