/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.antlr.v4.automata;

import com.autonomousapps.internal.antlr.runtime.tree.CommonTree;
import com.autonomousapps.internal.antlr.v4.tool.ErrorType;
import com.autonomousapps.internal.antlr.v4.tool.Grammar;

public class RangeBorderCharactersData {
    public final int lowerFrom;
    public final int upperFrom;
    public final int lowerTo;
    public final int upperTo;
    public final boolean mixOfLowerAndUpperCharCase;

    public RangeBorderCharactersData(int lowerFrom, int upperFrom, int lowerTo, int upperTo, boolean mixOfLowerAndUpperCharCase) {
        this.lowerFrom = lowerFrom;
        this.upperFrom = upperFrom;
        this.lowerTo = lowerTo;
        this.upperTo = upperTo;
        this.mixOfLowerAndUpperCharCase = mixOfLowerAndUpperCharCase;
    }

    public static RangeBorderCharactersData getAndCheckCharactersData(int from, int to, Grammar grammar, CommonTree tree, boolean reportRangeContainsNotImpliedCharacters) {
        boolean mixOfLowerAndUpperCharCase;
        int lowerFrom = Character.toLowerCase(from);
        int upperFrom = Character.toUpperCase(from);
        int lowerTo = Character.toLowerCase(to);
        int upperTo = Character.toUpperCase(to);
        boolean isLowerFrom = lowerFrom == from;
        boolean isLowerTo = lowerTo == to;
        boolean bl = mixOfLowerAndUpperCharCase = isLowerFrom && !isLowerTo || !isLowerFrom && isLowerTo;
        if (reportRangeContainsNotImpliedCharacters && mixOfLowerAndUpperCharCase && from <= 127 && to <= 127) {
            StringBuilder notImpliedCharacters = new StringBuilder();
            for (int i = from; i < to; ++i) {
                if (Character.isAlphabetic(i)) continue;
                notImpliedCharacters.append((char)i);
            }
            if (notImpliedCharacters.length() > 0) {
                grammar.tool.errMgr.grammarError(ErrorType.RANGE_PROBABLY_CONTAINS_NOT_IMPLIED_CHARACTERS, grammar.fileName, tree.getToken(), Character.valueOf((char)from), Character.valueOf((char)to), notImpliedCharacters.toString());
            }
        }
        return new RangeBorderCharactersData(lowerFrom, upperFrom, lowerTo, upperTo, mixOfLowerAndUpperCharCase);
    }

    public boolean isSingleRange() {
        return this.lowerFrom == this.upperFrom && this.lowerTo == this.upperTo || this.mixOfLowerAndUpperCharCase || this.lowerTo - this.lowerFrom != this.upperTo - this.upperFrom;
    }
}

