/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.antlr.v4.codegen.target;

import com.autonomousapps.internal.antlr.v4.codegen.CodeGenerator;
import com.autonomousapps.internal.antlr.v4.codegen.Target;
import com.autonomousapps.internal.antlr.v4.tool.Grammar;
import com.autonomousapps.internal.stringtemplate.v4.ST;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GoTarget
extends Target {
    protected static final HashSet<String> reservedWords = new HashSet<String>(Arrays.asList("break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "bool", "byte", "complex64", "complex128", "error", "float32", "float64", "int", "int8", "int16", "int32", "int64", "rune", "string", "uint", "uint8", "uint16", "uint32", "uint64", "uintptr", "true", "false", "iota", "nil", "append", "cap", "close", "complex", "copy", "delete", "imag", "len", "make", "new", "panic", "print", "println", "real", "recover", "string", "Accept", "GetAltNumber", "GetBaseRuleContext", "GetChild", "GetChildCount", "GetChildren", "GetInvokingState", "GetParent", "GetPayload", "GetRuleContext", "GetRuleIndex", "GetSourceInterval", "GetText", "IsEmpty", "SetAltNumber", "SetInvokingState", "SetParent", "String", "rule", "parserRule", "action", "start", "stop", "exception", "sempred", "precpred", "addErrorListener"));
    private static final boolean DO_GOFMT = !Boolean.parseBoolean(System.getenv("ANTLR_GO_DISABLE_GOFMT")) && !Boolean.parseBoolean(System.getProperty("antlr.go.disable-gofmt"));

    public GoTarget(CodeGenerator gen) {
        super(gen);
    }

    @Override
    protected Set<String> getReservedWords() {
        return reservedWords;
    }

    @Override
    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        super.genFile(g, outputFileST, fileName);
        if (DO_GOFMT && !fileName.startsWith(".") && fileName.endsWith(".go")) {
            this.gofmt(new File(this.getCodeGenerator().tool.getOutputDirectory(g.fileName), fileName));
        }
    }

    private void gofmt(File fileName) {
        try {
            ProcessBuilder gofmtBuilder = new ProcessBuilder("gofmt", "-w", "-s", fileName.getPath());
            gofmtBuilder.redirectErrorStream(true);
            Process gofmt = gofmtBuilder.start();
            InputStream stdout = gofmt.getInputStream();
            byte[] buf = new byte[1024];
            int l = 0;
            while (l > -1) {
                l = stdout.read(buf);
            }
            gofmt.waitFor();
        }
        catch (IOException gofmtBuilder) {
        }
        catch (InterruptedException forward) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String getRecognizerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g != null);
        switch (g.getType()) {
            case 44: {
                String name = g.name.endsWith("Parser") ? g.name.substring(0, g.name.length() - 6) : g.name;
                return name.toLowerCase() + "_parser.go";
            }
            case 31: {
                String name = g.name.endsWith("Lexer") ? g.name.substring(0, g.name.length() - 5) : g.name;
                return name.toLowerCase() + "_lexer.go";
            }
            case 72: {
                return g.name.toLowerCase() + "_parser.go";
            }
        }
        return "INVALID_FILE_NAME";
    }

    @Override
    public String getListenerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_listener.go";
    }

    @Override
    public String getVisitorFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_visitor.go";
    }

    @Override
    public String getBaseListenerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_base_listener.go";
    }

    @Override
    public String getBaseVisitorFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_base_visitor.go";
    }
}

