/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3.internal;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Optional;
import lombok.NonNull;
import org.reactivestreams.Publisher;

public class ZipAll<T, R> {
    private static final Predicate<?> PREDICATE = in -> {
        Object[] objs;
        for (Object obj : objs = (Object[])in) {
            if (!((Optional)obj).isPresent()) continue;
            return true;
        }
        return false;
    };
    private static final Function<Object[], Object[]> IDENTITY = v -> v;
    @NonNull
    private final Function<? super Object[], ? extends R> zipper;
    private final boolean delayError;
    private final int bufferSize;
    @NonNull
    private final Publisher[] sources;

    public Flowable<R> createFlowable() {
        return Flowable.zipArray(IDENTITY, (boolean)this.delayError, (int)this.bufferSize, (Publisher[])this.padSources()).takeWhile(PREDICATE).map(this.zipper);
    }

    private Publisher[] padSources() {
        Publisher[] padded = new Publisher[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            padded[i] = Flowable.concat(this.map(this.sources[i]), this.pad());
        }
        return padded;
    }

    private Publisher<Optional<?>> map(Publisher<?> source) {
        return Flowable.fromPublisher(source).map(Optional::of);
    }

    private Publisher<Optional<?>> pad() {
        return Flowable.generate(emitter -> emitter.onNext(Optional.empty()));
    }

    public ZipAll(@NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, @NonNull Publisher[] sources) {
        if (zipper == null) {
            throw new NullPointerException("zipper is marked non-null but is null");
        }
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        this.zipper = zipper;
        this.delayError = delayError;
        this.bufferSize = bufferSize;
        this.sources = sources;
    }
}

