/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.collection;

import com.autonomouslogic.commons.collection.ConcatCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;

public class ConcatList<E>
extends ConcatCollection<E>
implements List<E> {
    private final List<List<E>> lists;

    public ConcatList(List<List<E>> lists) {
        super(new ArrayList(lists));
        this.lists = new ArrayList<List<List<E>>>(lists);
    }

    @Override
    public E get(int i) {
        this.validateIndex(i);
        int min = 0;
        for (List<E> list : this.lists) {
            int s = list.size();
            int max = min + s;
            if (i < max) {
                return list.get(i - min);
            }
            min = max;
        }
        throw new IllegalStateException();
    }

    @Override
    public E set(int i, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int offset = 0;
        for (List<E> list : this.lists) {
            int i = list.indexOf(o);
            if (i >= 0) {
                return offset + i;
            }
            offset += list.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int n = this.lists.size();
        for (int l = n - 1; l >= 0; --l) {
            List<E> list = this.lists.get(l);
            int i = list.lastIndexOf(o);
            if (i < 0) continue;
            for (int r = l - 1; r >= 0; --r) {
                i += this.lists.get(r).size();
            }
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int i, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    private void validateIndex(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }
}

