/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper;

import com.autonomouslogic.dynamomapper.DynamoAsyncMapperBuilder;
import com.autonomouslogic.dynamomapper.codec.DynamoDecoder;
import com.autonomouslogic.dynamomapper.codec.DynamoEncoder;
import com.autonomouslogic.dynamomapper.function.CheckedFunction;
import com.autonomouslogic.dynamomapper.function.TableNameDecorator;
import com.autonomouslogic.dynamomapper.model.MappedBatchGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedDeleteItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedPutItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedQueryResponse;
import com.autonomouslogic.dynamomapper.model.MappedScanResponse;
import com.autonomouslogic.dynamomapper.model.MappedUpdateItemResponse;
import com.autonomouslogic.dynamomapper.request.RequestFactory;
import com.autonomouslogic.dynamomapper.util.FutureUtil;
import com.autonomouslogic.dynamomapper.util.ReflectionUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

public class DynamoAsyncMapper {
    private final DynamoDbAsyncClient client;
    final DynamoEncoder encoder;
    final DynamoDecoder decoder;
    final RequestFactory requestFactory;
    final ReflectionUtil reflectionUtil;

    protected DynamoAsyncMapper(DynamoDbAsyncClient client, ObjectMapper objectMapper, TableNameDecorator tableNameDecorator) {
        this.client = client;
        this.reflectionUtil = new ReflectionUtil(objectMapper, tableNameDecorator);
        this.encoder = new DynamoEncoder(objectMapper, this.reflectionUtil);
        this.decoder = new DynamoDecoder(objectMapper);
        this.requestFactory = new RequestFactory(this.encoder, objectMapper, this.reflectionUtil);
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItem(@NonNull Consumer<GetItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<GetItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptGetItemRequest((GetItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((GetItemRequest.Builder)builder);
        };
        return this.client.getItem(reqOrConsumer).thenApply((Function)new CheckedFunction<GetItemResponse, MappedGetItemResponse<T>>(){

            @Override
            public MappedGetItemResponse<T> checkedApply(GetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapGetItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Consumer<GetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromPrimaryKey(primaryKey, clazz);
        consumer.accept(builder);
        return this.getItem((GetItemRequest)builder.build(), clazz);
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<GetItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.getItem((GetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItem(@NonNull GetItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest reqOrConsumer = this.requestFactory.acceptGetItemRequest(request, clazz);
        return this.client.getItem(reqOrConsumer).thenApply((Function)new CheckedFunction<GetItemResponse, MappedGetItemResponse<T>>(){

            @Override
            public MappedGetItemResponse<T> checkedApply(GetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapGetItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromPrimaryKey(primaryKey, clazz);
        return this.getItem((GetItemRequest)builder.build(), clazz);
    }

    public <T> CompletableFuture<MappedGetItemResponse<T>> getItemFromKeyObject(@NonNull T keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromKeyObject(keyObject);
        return this.getItem((GetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItem(@NonNull BatchGetItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest reqOrConsumer = this.requestFactory.acceptBatchGetItemRequest(request, clazz);
        return this.client.batchGetItem(reqOrConsumer).thenApply((Function)new CheckedFunction<BatchGetItemResponse, MappedBatchGetItemResponse<T>>(){

            @Override
            public MappedBatchGetItemResponse<T> checkedApply(BatchGetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapBatchGetItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItemFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Class<T> clazz) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FutureUtil.wrapFuture(() -> {
            BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
            return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
        });
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItemFromKeyObjects(@NonNull List<?> keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItem(@NonNull Consumer<BatchGetItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<BatchGetItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptBatchGetItemRequest((BatchGetItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((BatchGetItemRequest.Builder)builder);
        };
        return this.client.batchGetItem(reqOrConsumer).thenApply((Function)new CheckedFunction<BatchGetItemResponse, MappedBatchGetItemResponse<T>>(){

            @Override
            public MappedBatchGetItemResponse<T> checkedApply(BatchGetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapBatchGetItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItemFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Consumer<BatchGetItemRequest.Builder> consumer, @NonNull Class<T> clazz) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FutureUtil.wrapFuture(() -> {
            BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
            consumer.accept(builder);
            return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
        });
    }

    public <T> CompletableFuture<MappedBatchGetItemResponse<T>> batchGetItemFromKeyObjects(@NonNull List<?> keyObject, @NonNull Consumer<BatchGetItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        consumer.accept(builder);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedPutItemResponse<T>> putItem(@NonNull Consumer<PutItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<PutItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptPutItemRequest((PutItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((PutItemRequest.Builder)builder);
        };
        return this.client.putItem(reqOrConsumer).thenApply((Function)new CheckedFunction<PutItemResponse, MappedPutItemResponse<T>>(){

            @Override
            public MappedPutItemResponse<T> checkedApply(PutItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapPutItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedPutItemResponse<T>> putItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<PutItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        PutItemRequest.Builder builder = this.requestFactory.putItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.putItem((PutItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedPutItemResponse<T>> putItem(@NonNull PutItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        PutItemRequest reqOrConsumer = this.requestFactory.acceptPutItemRequest(request, clazz);
        return this.client.putItem(reqOrConsumer).thenApply((Function)new CheckedFunction<PutItemResponse, MappedPutItemResponse<T>>(){

            @Override
            public MappedPutItemResponse<T> checkedApply(PutItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapPutItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedPutItemResponse<T>> putItemFromKeyObject(@NonNull T keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        PutItemRequest.Builder builder = this.requestFactory.putItemRequestFromKeyObject(keyObject);
        return this.putItem((PutItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedUpdateItemResponse<T>> updateItem(@NonNull Consumer<UpdateItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<UpdateItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptUpdateItemRequest((UpdateItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((UpdateItemRequest.Builder)builder);
        };
        return this.client.updateItem(reqOrConsumer).thenApply((Function)new CheckedFunction<UpdateItemResponse, MappedUpdateItemResponse<T>>(){

            @Override
            public MappedUpdateItemResponse<T> checkedApply(UpdateItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapUpdateItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedUpdateItemResponse<T>> updateItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<UpdateItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        UpdateItemRequest.Builder builder = this.requestFactory.updateItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.updateItem((UpdateItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedUpdateItemResponse<T>> updateItem(@NonNull UpdateItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        UpdateItemRequest reqOrConsumer = this.requestFactory.acceptUpdateItemRequest(request, clazz);
        return this.client.updateItem(reqOrConsumer).thenApply((Function)new CheckedFunction<UpdateItemResponse, MappedUpdateItemResponse<T>>(){

            @Override
            public MappedUpdateItemResponse<T> checkedApply(UpdateItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapUpdateItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedUpdateItemResponse<T>> updateItemFromKeyObject(@NonNull T keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        UpdateItemRequest.Builder builder = this.requestFactory.updateItemRequestFromKeyObject(keyObject);
        return this.updateItem((UpdateItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItem(@NonNull Consumer<DeleteItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<DeleteItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptDeleteItemRequest((DeleteItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((DeleteItemRequest.Builder)builder);
        };
        return this.client.deleteItem(reqOrConsumer).thenApply((Function)new CheckedFunction<DeleteItemResponse, MappedDeleteItemResponse<T>>(){

            @Override
            public MappedDeleteItemResponse<T> checkedApply(DeleteItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapDeleteItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Consumer<DeleteItemRequest.Builder> consumer, @NonNull Class<T> clazz) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FutureUtil.wrapFuture(() -> {
            DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromPrimaryKey(primaryKey, clazz);
            consumer.accept(builder);
            return this.deleteItem((DeleteItemRequest)builder.build(), clazz);
        });
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<DeleteItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.deleteItem((DeleteItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItem(@NonNull DeleteItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        DeleteItemRequest reqOrConsumer = this.requestFactory.acceptDeleteItemRequest(request, clazz);
        return this.client.deleteItem(reqOrConsumer).thenApply((Function)new CheckedFunction<DeleteItemResponse, MappedDeleteItemResponse<T>>(){

            @Override
            public MappedDeleteItemResponse<T> checkedApply(DeleteItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapDeleteItemResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FutureUtil.wrapFuture(() -> {
            DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromPrimaryKey(primaryKey, clazz);
            return this.deleteItem((DeleteItemRequest)builder.build(), clazz);
        });
    }

    public <T> CompletableFuture<MappedDeleteItemResponse<T>> deleteItemFromKeyObject(@NonNull T keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromKeyObject(keyObject);
        return this.deleteItem((DeleteItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> CompletableFuture<MappedScanResponse<T>> scan(@NonNull Consumer<ScanRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<ScanRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptScanRequest((ScanRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((ScanRequest.Builder)builder);
        };
        return this.client.scan(reqOrConsumer).thenApply((Function)new CheckedFunction<ScanResponse, MappedScanResponse<T>>(){

            @Override
            public MappedScanResponse<T> checkedApply(ScanResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapScanResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedScanResponse<T>> scan(@NonNull ScanRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ScanRequest reqOrConsumer = this.requestFactory.acceptScanRequest(request, clazz);
        return this.client.scan(reqOrConsumer).thenApply((Function)new CheckedFunction<ScanResponse, MappedScanResponse<T>>(){

            @Override
            public MappedScanResponse<T> checkedApply(ScanResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapScanResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedQueryResponse<T>> query(@NonNull Consumer<QueryRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<QueryRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptQueryRequest((QueryRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((QueryRequest.Builder)builder);
        };
        return this.client.query(reqOrConsumer).thenApply((Function)new CheckedFunction<QueryResponse, MappedQueryResponse<T>>(){

            @Override
            public MappedQueryResponse<T> checkedApply(QueryResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapQueryResponse(response, clazz);
            }
        });
    }

    public <T> CompletableFuture<MappedQueryResponse<T>> query(@NonNull QueryRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        QueryRequest reqOrConsumer = this.requestFactory.acceptQueryRequest(request, clazz);
        return this.client.query(reqOrConsumer).thenApply((Function)new CheckedFunction<QueryResponse, MappedQueryResponse<T>>(){

            @Override
            public MappedQueryResponse<T> checkedApply(QueryResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapQueryResponse(response, clazz);
            }
        });
    }

    public static DynamoAsyncMapperBuilder builder() {
        return new DynamoAsyncMapperBuilder();
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginator(@NonNull BatchGetItemRequest request, final @NonNull Class<T> clazz) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest reqOrConsumer = this.requestFactory.acceptBatchGetItemRequest(request, clazz);
        return this.client.batchGetItemPaginator(reqOrConsumer).map((Function)new CheckedFunction<BatchGetItemResponse, MappedBatchGetItemResponse<T>>(){

            @Override
            public MappedBatchGetItemResponse<T> checkedApply(BatchGetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapBatchGetItemResponse(response, clazz);
            }
        });
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginatorFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
        return this.batchGetItemPaginator((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginatorFromKeyObjects(@NonNull List<?> keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        return this.batchGetItemPaginator((BatchGetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginator(@NonNull Consumer<BatchGetItemRequest.Builder> consumer, final @NonNull Class<T> clazz) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<BatchGetItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptBatchGetItemRequest((BatchGetItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((BatchGetItemRequest.Builder)builder);
        };
        return this.client.batchGetItemPaginator(reqOrConsumer).map((Function)new CheckedFunction<BatchGetItemResponse, MappedBatchGetItemResponse<T>>(){

            @Override
            public MappedBatchGetItemResponse<T> checkedApply(BatchGetItemResponse response) throws Exception {
                return DynamoAsyncMapper.this.decoder.mapBatchGetItemResponse(response, clazz);
            }
        });
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginatorFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Consumer<BatchGetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
        consumer.accept(builder);
        return this.batchGetItemPaginator((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> Publisher<MappedBatchGetItemResponse<T>> batchGetItemPaginatorFromKeyObjects(@NonNull List<?> keyObject, @NonNull Consumer<BatchGetItemRequest.Builder> consumer) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        consumer.accept(builder);
        return this.batchGetItemPaginator((BatchGetItemRequest)builder.build(), keyObject.getClass());
    }
}

