/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper.codec;

import com.autonomouslogic.dynamomapper.util.ReflectionUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;

public class DynamoEncoder {
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final ReflectionUtil reflectionUtil;

    public Map<String, AttributeValue> encode(@NonNull Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        JsonNode json = this.objectMapper.valueToTree(obj);
        if (json.isObject()) {
            return this.encodeObject(json);
        }
        throw new IllegalArgumentException(String.format("Can only encode objects, %s supplied", json.getNodeType()));
    }

    private Map<String, AttributeValue> encodeObject(@NonNull JsonNode node) throws IOException {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            map.put((String)field.getKey(), this.encodeValue((JsonNode)field.getValue()));
        }
        return map;
    }

    public AttributeValue encodeValue(JsonNode node) throws IOException {
        if (node == null || node.isNull()) {
            return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        }
        if (node.isBinary()) {
            return (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArrayUnsafe((byte[])node.binaryValue())).build();
        }
        if (node.isBoolean()) {
            return (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(node.booleanValue())).build();
        }
        if (node.isTextual()) {
            return (AttributeValue)AttributeValue.builder().s(node.textValue()).build();
        }
        if (node.isNumber()) {
            return (AttributeValue)AttributeValue.builder().n(node.numberValue().toString()).build();
        }
        if (node.isObject()) {
            Map<String, AttributeValue> obj = this.encodeObject(node);
            return (AttributeValue)AttributeValue.builder().m(obj).build();
        }
        if (node.isArray()) {
            return this.encodeList(node);
        }
        throw new IllegalArgumentException(String.format("Unsupported node type: %s", node.getNodeType()));
    }

    private AttributeValue encodeList(@NonNull JsonNode list) throws IOException {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
        for (JsonNode entry : list) {
            values.add(this.encodeValue(entry));
        }
        return (AttributeValue)AttributeValue.builder().l(values).build();
    }

    public <T> Map<String, AttributeValue> encodeKeyValue(@NonNull T keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        Map<String, AttributeValue> encoded = this.encode(keyObject);
        List<String> primaryKeys = this.reflectionUtil.resolvePrimaryKeyFields(keyObject.getClass());
        HashMap<String, AttributeValue> keyValues = new HashMap<String, AttributeValue>();
        for (String field : primaryKeys) {
            keyValues.put(field, encoded.get(field));
        }
        return keyValues;
    }

    public <T> Map<String, AttributeValue> encodeKeyValue(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        List<String> primaryKeys = this.reflectionUtil.resolvePrimaryKeyFields(clazz);
        if (primaryKeys.isEmpty()) {
            throw new IllegalArgumentException(String.format("No primary key defined on %s", clazz.getSimpleName()));
        }
        if (primaryKeys.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple primary keys defined on %s", clazz.getSimpleName()));
        }
        JsonNode json = this.objectMapper.valueToTree(primaryKey);
        AttributeValue primaryKeyValue = this.encodeValue(json);
        return Map.of(primaryKeys.get(0), primaryKeyValue);
    }

    public Map<String, AttributeValueUpdate> encodeUpdates(@NonNull Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Map<String, AttributeValue> encoded = this.encode(obj);
        Map<String, AttributeValue> key = this.encodeKeyValue(obj);
        for (String k2 : key.keySet()) {
            encoded.remove(k2);
        }
        HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
        encoded.forEach((k, val) -> updates.put((String)k, (AttributeValueUpdate)AttributeValueUpdate.builder().value(val).action(AttributeAction.PUT).build()));
        return updates;
    }

    @Generated
    public DynamoEncoder(@NonNull ObjectMapper objectMapper, @NonNull ReflectionUtil reflectionUtil) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (reflectionUtil == null) {
            throw new NullPointerException("reflectionUtil is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.reflectionUtil = reflectionUtil;
    }
}

