/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper.request;

import com.autonomouslogic.dynamomapper.codec.DynamoEncoder;
import com.autonomouslogic.dynamomapper.util.ReflectionUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class RequestFactory {
    private final DynamoEncoder encoder;
    private final ObjectMapper objectMapper;
    private final ReflectionUtil reflectionUtil;

    public <T> GetItemRequest.Builder getItemRequestFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return GetItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(clazz)).key(this.encoder.encodeKeyValue(primaryKey, clazz));
    }

    public <T> GetItemRequest.Builder getItemRequestFromKeyObject(@NonNull Object keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        return GetItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(keyObject.getClass())).key(this.encoder.encodeKeyValue(keyObject));
    }

    public <T> BatchGetItemRequest.Builder batchGetItemRequestFromPrimaryKeys(@NonNull List<?> primaryKeys, @NonNull Class<T> clazz) throws IOException {
        if (primaryKeys == null) {
            throw new NullPointerException("primaryKeys is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        String tableName = this.reflectionUtil.resolveTableName(clazz);
        ArrayList<Map<String, AttributeValue>> keyObjects = new ArrayList<Map<String, AttributeValue>>(primaryKeys.size());
        for (Object primaryKey : primaryKeys) {
            keyObjects.add(this.encoder.encodeKeyValue(primaryKey, clazz));
        }
        return BatchGetItemRequest.builder().requestItems(Map.of(tableName, (KeysAndAttributes)KeysAndAttributes.builder().keys(keyObjects).build()));
    }

    public <T> BatchGetItemRequest.Builder batchGetItemRequestFromKeyObjects(@NonNull List<T> keyObjects) throws IOException {
        if (keyObjects == null) {
            throw new NullPointerException("keyObjects is marked non-null but is null");
        }
        Class<?> clazz = null;
        for (T k : keyObjects) {
            if (clazz == null) {
                clazz = k.getClass();
                continue;
            }
            if (clazz == k.getClass()) continue;
            throw new IllegalArgumentException(String.format("Key objects must be the same class, expected %s, but %s seen", clazz, k.getClass()));
        }
        String tableName = this.reflectionUtil.resolveTableName(clazz);
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(keyObjects.size());
        for (T primaryKey : keyObjects) {
            Map<String, AttributeValue> keyValue = this.encoder.encodeKeyValue(primaryKey);
            keys.add(keyValue);
        }
        return BatchGetItemRequest.builder().requestItems(Map.of(tableName, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build()));
    }

    public PutItemRequest.Builder putItemRequestFromKeyObject(@NonNull Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Map<String, AttributeValue> encoded = this.encoder.encode(obj);
        return PutItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(obj.getClass())).item(encoded);
    }

    public UpdateItemRequest.Builder updateItemRequestFromKeyObject(@NonNull Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Map<String, AttributeValue> key = this.encoder.encodeKeyValue(obj);
        Map<String, AttributeValueUpdate> updates = this.encoder.encodeUpdates(obj);
        return UpdateItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(obj.getClass())).key(key).attributeUpdates(updates);
    }

    public <T> DeleteItemRequest.Builder deleteItemRequestFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return DeleteItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(clazz)).key(this.encoder.encodeKeyValue(primaryKey, clazz));
    }

    public DeleteItemRequest.Builder deleteItemRequestFromKeyObject(@NonNull Object keyObject) throws IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        return DeleteItemRequest.builder().tableName(this.reflectionUtil.resolveTableName(keyObject.getClass())).key(this.encoder.encodeKeyValue(keyObject));
    }

    public GetItemRequest acceptGetItemRequest(@NonNull GetItemRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (GetItemRequest)this.acceptGetItemRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public GetItemRequest.Builder acceptGetItemRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GetItemRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    public BatchGetItemRequest acceptBatchGetItemRequest(@NonNull BatchGetItemRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Map items = req.requestItems();
        int types = items.size();
        if (types != 1) {
            throw new IllegalArgumentException(String.format("Exactly one class type expected, %s given: %s", types, items.keySet()));
        }
        return req;
    }

    public BatchGetItemRequest.Builder acceptBatchGetItemRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BatchGetItemRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req;
    }

    public PutItemRequest acceptPutItemRequest(@NonNull PutItemRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (PutItemRequest)this.acceptPutItemRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public PutItemRequest.Builder acceptPutItemRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PutItemRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    public UpdateItemRequest acceptUpdateItemRequest(@NonNull UpdateItemRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (UpdateItemRequest)this.acceptUpdateItemRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public UpdateItemRequest.Builder acceptUpdateItemRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UpdateItemRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    public DeleteItemRequest acceptDeleteItemRequest(@NonNull DeleteItemRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (DeleteItemRequest)this.acceptDeleteItemRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public DeleteItemRequest.Builder acceptDeleteItemRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull DeleteItemRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    public ScanRequest acceptScanRequest(@NonNull ScanRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (ScanRequest)this.acceptScanRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public ScanRequest.Builder acceptScanRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ScanRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    public QueryRequest acceptQueryRequest(@NonNull QueryRequest req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (req.tableName() == null) {
            return (QueryRequest)this.acceptQueryRequest(req.toBuilder(), clazz).build();
        }
        return req;
    }

    public QueryRequest.Builder acceptQueryRequest(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull QueryRequest.Builder req, @NonNull Class<?> clazz) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return req.tableName(this.reflectionUtil.resolveTableName(clazz));
    }

    @Generated
    public RequestFactory(DynamoEncoder encoder, ObjectMapper objectMapper, ReflectionUtil reflectionUtil) {
        this.encoder = encoder;
        this.objectMapper = objectMapper;
        this.reflectionUtil = reflectionUtil;
    }
}

