/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper;

import com.autonomouslogic.dynamomapper.DynamoMapperBuilder;
import com.autonomouslogic.dynamomapper.codec.DynamoDecoder;
import com.autonomouslogic.dynamomapper.codec.DynamoEncoder;
import com.autonomouslogic.dynamomapper.function.TableNameDecorator;
import com.autonomouslogic.dynamomapper.model.MappedBatchGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedDeleteItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedPutItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedQueryResponse;
import com.autonomouslogic.dynamomapper.model.MappedScanResponse;
import com.autonomouslogic.dynamomapper.model.MappedUpdateItemResponse;
import com.autonomouslogic.dynamomapper.request.RequestFactory;
import com.autonomouslogic.dynamomapper.util.ReflectionUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ReplicatedWriteConflictException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoMapper {
    private final DynamoDbClient client;
    final DynamoEncoder encoder;
    final DynamoDecoder decoder;
    final RequestFactory requestFactory;
    final ReflectionUtil reflectionUtil;

    protected DynamoMapper(DynamoDbClient client, ObjectMapper objectMapper, TableNameDecorator tableNameDecorator) {
        this.client = client;
        this.reflectionUtil = new ReflectionUtil(objectMapper, tableNameDecorator);
        this.encoder = new DynamoEncoder(objectMapper, this.reflectionUtil);
        this.decoder = new DynamoDecoder(objectMapper);
        this.requestFactory = new RequestFactory(this.encoder, objectMapper, this.reflectionUtil);
    }

    public <T> MappedGetItemResponse<T> getItem(@NonNull Consumer<GetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<GetItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptGetItemRequest((GetItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((GetItemRequest.Builder)builder);
        };
        return this.decoder.mapGetItemResponse(this.client.getItem(reqOrConsumer), clazz);
    }

    public <T> MappedGetItemResponse<T> getItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Consumer<GetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromPrimaryKey(primaryKey, clazz);
        consumer.accept(builder);
        return this.getItem((GetItemRequest)builder.build(), clazz);
    }

    public <T> MappedGetItemResponse<T> getItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<GetItemRequest.Builder> consumer) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.getItem((GetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedGetItemResponse<T> getItem(@NonNull GetItemRequest request, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest reqOrConsumer = this.requestFactory.acceptGetItemRequest(request, clazz);
        return this.decoder.mapGetItemResponse(this.client.getItem(reqOrConsumer), clazz);
    }

    public <T> MappedGetItemResponse<T> getItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromPrimaryKey(primaryKey, clazz);
        return this.getItem((GetItemRequest)builder.build(), clazz);
    }

    public <T> MappedGetItemResponse<T> getItemFromKeyObject(@NonNull T keyObject) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        GetItemRequest.Builder builder = this.requestFactory.getItemRequestFromKeyObject(keyObject);
        return this.getItem((GetItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItem(@NonNull BatchGetItemRequest request, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest reqOrConsumer = this.requestFactory.acceptBatchGetItemRequest(request, clazz);
        return this.decoder.mapBatchGetItemResponse(this.client.batchGetItem(reqOrConsumer), clazz);
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItemFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItemFromKeyObjects(@NonNull List<T> keyObject, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItem(@NonNull Consumer<BatchGetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<BatchGetItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptBatchGetItemRequest((BatchGetItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((BatchGetItemRequest.Builder)builder);
        };
        return this.decoder.mapBatchGetItemResponse(this.client.batchGetItem(reqOrConsumer), clazz);
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItemFromPrimaryKeys(@NonNull List<?> primaryKey, @NonNull Consumer<BatchGetItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromPrimaryKeys(primaryKey, clazz);
        consumer.accept(builder);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> MappedBatchGetItemResponse<T> batchGetItemFromKeyObjects(@NonNull List<T> keyObject, @NonNull Class<T> clazz, @NonNull Consumer<BatchGetItemRequest.Builder> consumer) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        BatchGetItemRequest.Builder builder = this.requestFactory.batchGetItemRequestFromKeyObjects(keyObject);
        consumer.accept(builder);
        return this.batchGetItem((BatchGetItemRequest)builder.build(), clazz);
    }

    public <T> MappedPutItemResponse<T> putItem(@NonNull Consumer<PutItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<PutItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptPutItemRequest((PutItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((PutItemRequest.Builder)builder);
        };
        return this.decoder.mapPutItemResponse(this.client.putItem(reqOrConsumer), clazz);
    }

    public <T> MappedPutItemResponse<T> putItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<PutItemRequest.Builder> consumer) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        PutItemRequest.Builder builder = this.requestFactory.putItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.putItem((PutItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedPutItemResponse<T> putItem(@NonNull PutItemRequest request, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        PutItemRequest reqOrConsumer = this.requestFactory.acceptPutItemRequest(request, clazz);
        return this.decoder.mapPutItemResponse(this.client.putItem(reqOrConsumer), clazz);
    }

    public <T> MappedPutItemResponse<T> putItemFromKeyObject(@NonNull T keyObject) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        PutItemRequest.Builder builder = this.requestFactory.putItemRequestFromKeyObject(keyObject);
        return this.putItem((PutItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedUpdateItemResponse<T> updateItem(@NonNull Consumer<UpdateItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<UpdateItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptUpdateItemRequest((UpdateItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((UpdateItemRequest.Builder)builder);
        };
        return this.decoder.mapUpdateItemResponse(this.client.updateItem(reqOrConsumer), clazz);
    }

    public <T> MappedUpdateItemResponse<T> updateItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<UpdateItemRequest.Builder> consumer) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        UpdateItemRequest.Builder builder = this.requestFactory.updateItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.updateItem((UpdateItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedUpdateItemResponse<T> updateItem(@NonNull UpdateItemRequest request, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        UpdateItemRequest reqOrConsumer = this.requestFactory.acceptUpdateItemRequest(request, clazz);
        return this.decoder.mapUpdateItemResponse(this.client.updateItem(reqOrConsumer), clazz);
    }

    public <T> MappedUpdateItemResponse<T> updateItemFromKeyObject(@NonNull T keyObject) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        UpdateItemRequest.Builder builder = this.requestFactory.updateItemRequestFromKeyObject(keyObject);
        return this.updateItem((UpdateItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedDeleteItemResponse<T> deleteItem(@NonNull Consumer<DeleteItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<DeleteItemRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptDeleteItemRequest((DeleteItemRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((DeleteItemRequest.Builder)builder);
        };
        return this.decoder.mapDeleteItemResponse(this.client.deleteItem(reqOrConsumer), clazz);
    }

    public <T> MappedDeleteItemResponse<T> deleteItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Consumer<DeleteItemRequest.Builder> consumer, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromPrimaryKey(primaryKey, clazz);
        consumer.accept(builder);
        return this.deleteItem((DeleteItemRequest)builder.build(), clazz);
    }

    public <T> MappedDeleteItemResponse<T> deleteItemFromKeyObject(@NonNull T keyObject, @NonNull Consumer<DeleteItemRequest.Builder> consumer) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromKeyObject(keyObject);
        consumer.accept(builder);
        return this.deleteItem((DeleteItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedDeleteItemResponse<T> deleteItem(@NonNull DeleteItemRequest request, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        DeleteItemRequest reqOrConsumer = this.requestFactory.acceptDeleteItemRequest(request, clazz);
        return this.decoder.mapDeleteItemResponse(this.client.deleteItem(reqOrConsumer), clazz);
    }

    public <T> MappedDeleteItemResponse<T> deleteItemFromPrimaryKey(@NonNull Object primaryKey, @NonNull Class<T> clazz) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromPrimaryKey(primaryKey, clazz);
        return this.deleteItem((DeleteItemRequest)builder.build(), clazz);
    }

    public <T> MappedDeleteItemResponse<T> deleteItemFromKeyObject(@NonNull T keyObject) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException, IOException {
        if (keyObject == null) {
            throw new NullPointerException("keyObject is marked non-null but is null");
        }
        DeleteItemRequest.Builder builder = this.requestFactory.deleteItemRequestFromKeyObject(keyObject);
        return this.deleteItem((DeleteItemRequest)builder.build(), keyObject.getClass());
    }

    public <T> MappedScanResponse<T> scan(@NonNull Consumer<ScanRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<ScanRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptScanRequest((ScanRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((ScanRequest.Builder)builder);
        };
        return this.decoder.mapScanResponse(this.client.scan(reqOrConsumer), clazz);
    }

    public <T> MappedScanResponse<T> scan(@NonNull ScanRequest request, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ScanRequest reqOrConsumer = this.requestFactory.acceptScanRequest(request, clazz);
        return this.decoder.mapScanResponse(this.client.scan(reqOrConsumer), clazz);
    }

    public <T> MappedQueryResponse<T> query(@NonNull Consumer<QueryRequest.Builder> consumer, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Consumer<QueryRequest.Builder> reqOrConsumer = builder -> {
            this.requestFactory.acceptQueryRequest((QueryRequest.Builder)builder, (Class<?>)clazz);
            consumer.accept((QueryRequest.Builder)builder);
        };
        return this.decoder.mapQueryResponse(this.client.query(reqOrConsumer), clazz);
    }

    public <T> MappedQueryResponse<T> query(@NonNull QueryRequest request, @NonNull Class<T> clazz) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException, JsonProcessingException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        QueryRequest reqOrConsumer = this.requestFactory.acceptQueryRequest(request, clazz);
        return this.decoder.mapQueryResponse(this.client.query(reqOrConsumer), clazz);
    }

    public static DynamoMapperBuilder builder() {
        return new DynamoMapperBuilder();
    }
}

