/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper;

import com.autonomouslogic.dynamomapper.DynamoMapper;
import com.autonomouslogic.dynamomapper.function.TableNameDecorator;
import com.autonomouslogic.dynamomapper.util.StdObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import lombok.Generated;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class DynamoMapperBuilder {
    private DynamoDbClient client;
    private ObjectMapper objectMapper;
    private TableNameDecorator tableNameDecorator;

    public DynamoMapper build() {
        DynamoDbClient client = Optional.ofNullable(this.client).orElseGet(DynamoDbClient::create);
        ObjectMapper objectMapper = Optional.ofNullable(this.objectMapper).orElseGet(StdObjectMapper::objectMapper);
        return new DynamoMapper(client, objectMapper, this.tableNameDecorator);
    }

    @Generated
    public DynamoMapperBuilder client(DynamoDbClient client) {
        this.client = client;
        return this;
    }

    @Generated
    public DynamoMapperBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    @Generated
    public DynamoMapperBuilder tableNameDecorator(TableNameDecorator tableNameDecorator) {
        this.tableNameDecorator = tableNameDecorator;
        return this;
    }
}

