/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper.codec;

import com.autonomouslogic.dynamomapper.model.MappedBatchGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedDeleteItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedGetItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedPutItemResponse;
import com.autonomouslogic.dynamomapper.model.MappedQueryResponse;
import com.autonomouslogic.dynamomapper.model.MappedScanResponse;
import com.autonomouslogic.dynamomapper.model.MappedUpdateItemResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

public class DynamoDecoder {
    @NonNull
    private final ObjectMapper objectMapper;

    public <T> MappedGetItemResponse<T> mapGetItemResponse(GetItemResponse response, Class<T> clazz) throws JsonProcessingException {
        Object item = response.hasItem() ? (Object)this.decode(response.item(), clazz) : null;
        return new MappedGetItemResponse<Object>(response, item);
    }

    public <T> MappedBatchGetItemResponse<T> mapBatchGetItemResponse(BatchGetItemResponse response, Class<T> clazz) throws JsonProcessingException {
        LinkedHashMap decodedResponses = null;
        if (response.hasResponses()) {
            decodedResponses = new LinkedHashMap();
            Map responses = response.responses();
            for (Map.Entry entry : responses.entrySet()) {
                String table = (String)entry.getKey();
                List values = (List)entry.getValue();
                ArrayList<T> items = new ArrayList<T>(values.size());
                decodedResponses.put(table, items);
                for (Map value : values) {
                    items.add(this.decode(value, clazz));
                }
            }
        }
        return new MappedBatchGetItemResponse(response, decodedResponses);
    }

    public <T> MappedPutItemResponse<T> mapPutItemResponse(PutItemResponse response, Class<T> clazz) throws JsonProcessingException {
        Object item = response.hasAttributes() ? (Object)this.decode(response.attributes(), clazz) : null;
        return new MappedPutItemResponse<Object>(response, item);
    }

    public <T> MappedUpdateItemResponse<T> mapUpdateItemResponse(UpdateItemResponse response, Class<T> clazz) throws JsonProcessingException {
        Object item = response.hasAttributes() ? (Object)this.decode(response.attributes(), clazz) : null;
        return new MappedUpdateItemResponse<Object>(response, item);
    }

    public <T> MappedDeleteItemResponse<T> mapDeleteItemResponse(DeleteItemResponse response, Class<T> clazz) throws JsonProcessingException {
        Object item = response.hasAttributes() ? (Object)this.decode(response.attributes(), clazz) : null;
        return new MappedDeleteItemResponse<Object>(response, item);
    }

    public <T> MappedScanResponse<T> mapScanResponse(ScanResponse response, Class<T> clazz) throws JsonProcessingException {
        List<T> decoded = this.decodeItems(response.items(), clazz);
        return new MappedScanResponse<T>(response, decoded);
    }

    public <T> MappedQueryResponse<T> mapQueryResponse(QueryResponse response, Class<T> clazz) throws JsonProcessingException {
        List<T> decoded = this.decodeItems(response.items(), clazz);
        return new MappedQueryResponse<T>(response, decoded);
    }

    private <T> List<T> decodeItems(List<Map<String, AttributeValue>> items, Class<T> clazz) throws JsonProcessingException {
        if (items == null) {
            return null;
        }
        ArrayList<T> decoded = new ArrayList<T>(items.size());
        if (!items.isEmpty()) {
            decoded = new ArrayList(items.size());
            for (Map<String, AttributeValue> item : items) {
                decoded.add(this.decode(item, clazz));
            }
        }
        return decoded;
    }

    public <T> T decode(Map<String, AttributeValue> map, Class<T> clazz) throws JsonProcessingException {
        ObjectNode json = this.objectMapper.createObjectNode();
        for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
            json.set(entry.getKey(), this.decodeValue(entry.getValue()));
        }
        return (T)this.objectMapper.treeToValue((TreeNode)json, clazz);
    }

    private JsonNode decodeValue(AttributeValue val) {
        JsonNodeFactory nodeFactory = this.objectMapper.getNodeFactory();
        if (val.b() != null) {
            return this.decodeBinary(val.b());
        }
        if (val.bool() != null) {
            return this.decodeBoolean(val);
        }
        if (val.hasBs() && val.bs() != null) {
            return this.decodeBinarySet(val);
        }
        if (val.hasL() && val.l() != null) {
            return this.decodeList(val);
        }
        if (val.hasM() && val.m() != null) {
            return this.decodeMap(val);
        }
        if (val.n() != null) {
            return this.decodeNumber(val.n());
        }
        if (val.hasNs() && val.ns() != null) {
            return this.decodeNumberSet(val);
        }
        if (val.nul() != null) {
            return nodeFactory.nullNode();
        }
        if (val.s() != null) {
            return this.decodeString(val.s());
        }
        if (val.hasSs() && val.ss() != null) {
            return this.decodeStringSet(val);
        }
        throw new IllegalArgumentException(val.toString());
    }

    private BooleanNode decodeBoolean(AttributeValue val) {
        return this.objectMapper.getNodeFactory().booleanNode(val.bool().booleanValue());
    }

    private TextNode decodeString(String val) {
        return this.objectMapper.getNodeFactory().textNode(val);
    }

    private JsonNode decodeBinary(SdkBytes bytes) {
        return this.objectMapper.getNodeFactory().binaryNode(bytes.asByteArray());
    }

    private JsonNode decodeNumber(String num) {
        return this.decodeString(num);
    }

    private JsonNode decodeMap(AttributeValue val) {
        ObjectNode obj = this.objectMapper.getNodeFactory().objectNode();
        for (Map.Entry entry : val.m().entrySet()) {
            obj.set((String)entry.getKey(), this.decodeValue((AttributeValue)entry.getValue()));
        }
        return obj;
    }

    private JsonNode decodeList(AttributeValue val) {
        ArrayNode arr = this.objectMapper.getNodeFactory().arrayNode();
        for (AttributeValue entry : val.l()) {
            arr.add(this.decodeValue(entry));
        }
        return arr;
    }

    private JsonNode decodeBinarySet(AttributeValue val) {
        ArrayNode arr = this.objectMapper.getNodeFactory().arrayNode();
        for (SdkBytes entry : val.bs()) {
            arr.add(this.decodeBinary(entry));
        }
        return arr;
    }

    private JsonNode decodeNumberSet(AttributeValue val) {
        return this.decodeArray(val.ns(), this::decodeNumber);
    }

    private JsonNode decodeStringSet(AttributeValue val) {
        return this.decodeArray(val.ss(), this::decodeString);
    }

    private <T> ArrayNode decodeArray(List<T> vals, Function<T, JsonNode> f) {
        ArrayNode arr = this.objectMapper.getNodeFactory().arrayNode();
        for (T val : vals) {
            arr.add(f.apply(val));
        }
        return arr;
    }

    @Generated
    public DynamoDecoder(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
    }
}

