/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.dynamomapper.util;

import com.autonomouslogic.dynamomapper.annotations.DynamoPrimaryKey;
import com.autonomouslogic.dynamomapper.annotations.DynamoTableName;
import com.autonomouslogic.dynamomapper.function.TableNameDecorator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ReflectionUtil {
    private final Map<Class<?>, List<String>> primaryKeyCache = new ConcurrentHashMap();
    private final Map<Class<?>, String> tableNameCache = new ConcurrentHashMap();
    private final ObjectMapper objectMapper;
    private final TableNameDecorator tableNameDecorator;

    public List<String> resolvePrimaryKeyFields(Class clazz) {
        return this.primaryKeyCache.computeIfAbsent(clazz, ignore -> {
            List<PropertyWriter> properties = this.getProperties(clazz);
            ArrayList<String> primaryKeyFields = new ArrayList<String>();
            for (PropertyWriter property : properties) {
                AnnotatedMember member = property.getMember();
                DynamoPrimaryKey primaryKey = (DynamoPrimaryKey)member.getAnnotation(DynamoPrimaryKey.class);
                if (primaryKey == null) continue;
                primaryKeyFields.add(property.getName());
            }
            return Collections.unmodifiableList(primaryKeyFields);
        });
    }

    public List<PropertyWriter> getProperties(Class<?> clazz) {
        try {
            SerializerProvider provider = this.objectMapper.getSerializerProviderInstance();
            JsonSerializer serializer = provider.findTypedValueSerializer(clazz, true, null);
            ArrayList<PropertyWriter> properties = new ArrayList<PropertyWriter>();
            serializer.properties().forEachRemaining(properties::add);
            return properties;
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    public String resolveTableName(Class<?> clazz) {
        return this.tableNameCache.computeIfAbsent(clazz, ignore -> {
            DynamoTableName tableName = clazz.getAnnotation(DynamoTableName.class);
            if (tableName == null) {
                throw new IllegalArgumentException(String.format("Class %s is not annotated with @DynamoTableName", clazz.getSimpleName()));
            }
            String name = tableName.value();
            if (this.tableNameDecorator != null) {
                name = (String)this.tableNameDecorator.apply(clazz, name);
            }
            return name;
        });
    }

    @Generated
    public ReflectionUtil(ObjectMapper objectMapper, TableNameDecorator tableNameDecorator) {
        this.objectMapper = objectMapper;
        this.tableNameDecorator = tableNameDecorator;
    }
}

