/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.config.BeanConfiguration;
import com.avanza.astrix.beans.core.AstrixBeanSettings;
import com.avanza.astrix.config.DynamicProperty;
import com.avanza.astrix.ft.hystrix.DynamicPropertyAdapter;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.properties.HystrixProperty;

final class AstrixCommandProperties
extends HystrixCommandProperties {
    private final HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy;
    private final DynamicPropertyAdapter<Integer> executionTimeoutInMilliseconds;
    private final HystrixProperty<Boolean> circuitBreakerEnabled;
    private final HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage;
    private final HystrixProperty<Boolean> circuitBreakerForceClosed;
    private final HystrixProperty<Boolean> circuitBreakerForceOpen;
    private final HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold;
    private final HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds;
    private final HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests;
    private final HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout;
    private final HystrixProperty<String> executionIsolationThreadPoolKeyOverride;
    private final HystrixProperty<Boolean> executionTimeoutEnabled;
    private final HystrixProperty<Boolean> fallbackEnabled;
    private final HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingPercentileBucketSize;
    private final HystrixProperty<Boolean> metricsRollingPercentileEnabled;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds;
    private final HystrixProperty<Boolean> requestCacheEnabled;
    private final HystrixProperty<Boolean> requestLogEnabled;

    AstrixCommandProperties(BeanConfiguration beanConfiguration, HystrixCommandKey key, HystrixCommandProperties.Setter builder) {
        super(key, builder);
        this.isolationStrategy = builder.getExecutionIsolationStrategy();
        this.executionTimeoutInMilliseconds = new DynamicPropertyAdapter(beanConfiguration.get(AstrixBeanSettings.TIMEOUT));
        this.circuitBreakerEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.circuitBreakerEnabled", true)));
        this.circuitBreakerErrorThresholdPercentage = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.circuitBreakerErrorThresholdPercentage", 50)));
        this.circuitBreakerForceClosed = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.circuitBreakerForceClosed", false)));
        this.circuitBreakerForceOpen = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.circuitBreakerForceOpen", false)));
        this.circuitBreakerRequestVolumeThreshold = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.circuitBreakerRequestVolumeThreshold", 20)));
        this.circuitBreakerSleepWindowInMilliseconds = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.circuitBreakerSleepWindowInMilliseconds", 5000)));
        this.executionIsolationSemaphoreMaxConcurrentRequests = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(AstrixBeanSettings.MAX_CONCURRENT_REQUESTS));
        this.executionIsolationThreadInterruptOnTimeout = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.executionIsolationThreadInterruptOnTimeout", true)));
        this.executionIsolationThreadPoolKeyOverride = new DynamicPropertyAdapter<String>((DynamicProperty<String>)beanConfiguration.get(new AstrixBeanSettings.StringBeanSetting("faultTolerance.executionIsolationThreadPoolKeyOverride", null)));
        this.executionTimeoutEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.executionTimeoutEnabled", true)));
        this.fallbackEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.fallbackEnabled", true)));
        this.metricsHealthSnapshotIntervalInMilliseconds = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsHealthSnapshotIntervalInMilliseconds", 500)));
        this.metricsRollingPercentileBucketSize = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsRollingPercentileBucketSize", 100)));
        this.metricsRollingPercentileEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.metricsRollingPercentileEnabled", true)));
        this.metricsRollingPercentileWindowBuckets = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsRollingPercentileWindowBuckets", 6)));
        this.metricsRollingPercentileWindowInMilliseconds = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsRollingPercentileWindowInMilliseconds", 60000)));
        this.metricsRollingStatisticalWindowBuckets = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsRollingStatisticalWindowBuckets", 10)));
        this.metricsRollingStatisticalWindowInMilliseconds = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(new AstrixBeanSettings.IntBeanSetting("faultTolerance.metricsRollingStatisticalWindowInMilliseconds", 10000)));
        this.requestCacheEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.requestCacheEnabled", false)));
        this.requestLogEnabled = new DynamicPropertyAdapter<Boolean>((DynamicProperty<Boolean>)beanConfiguration.get(new AstrixBeanSettings.BooleanBeanSetting("faultTolerance.requestLogEnabled", false)));
    }

    public HystrixProperty<Integer> executionTimeoutInMilliseconds() {
        return this.executionTimeoutInMilliseconds;
    }

    public HystrixProperty<Boolean> circuitBreakerEnabled() {
        return this.circuitBreakerEnabled;
    }

    public HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage() {
        return this.circuitBreakerErrorThresholdPercentage;
    }

    public HystrixProperty<Boolean> circuitBreakerForceClosed() {
        return this.circuitBreakerForceClosed;
    }

    public HystrixProperty<Boolean> circuitBreakerForceOpen() {
        return this.circuitBreakerForceOpen;
    }

    public HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold() {
        return this.circuitBreakerRequestVolumeThreshold;
    }

    public HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds() {
        return this.circuitBreakerSleepWindowInMilliseconds;
    }

    public HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests() {
        return this.executionIsolationSemaphoreMaxConcurrentRequests;
    }

    public HystrixProperty<HystrixCommandProperties.ExecutionIsolationStrategy> executionIsolationStrategy() {
        if (this.isolationStrategy != null) {
            return HystrixProperty.Factory.asProperty((Object)this.isolationStrategy);
        }
        return HystrixProperty.Factory.asProperty((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
    }

    public HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout() {
        return this.executionIsolationThreadInterruptOnTimeout;
    }

    public HystrixProperty<String> executionIsolationThreadPoolKeyOverride() {
        return this.executionIsolationThreadPoolKeyOverride;
    }

    @Deprecated
    public HystrixProperty<Integer> executionIsolationThreadTimeoutInMilliseconds() {
        return this.executionTimeoutInMilliseconds();
    }

    public HystrixProperty<Boolean> executionTimeoutEnabled() {
        return this.executionTimeoutEnabled;
    }

    public HystrixProperty<Boolean> fallbackEnabled() {
        return this.fallbackEnabled;
    }

    public HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests() {
        return HystrixProperty.Factory.asProperty((Object)Integer.MAX_VALUE);
    }

    public HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds() {
        return this.metricsHealthSnapshotIntervalInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileBucketSize() {
        return this.metricsRollingPercentileBucketSize;
    }

    public HystrixProperty<Boolean> metricsRollingPercentileEnabled() {
        return this.metricsRollingPercentileEnabled;
    }

    @Deprecated
    public HystrixProperty<Integer> metricsRollingPercentileWindow() {
        return this.metricsRollingPercentileWindowInMilliseconds();
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowBuckets() {
        return this.metricsRollingPercentileWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds() {
        return this.metricsRollingPercentileWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.metricsRollingStatisticalWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.metricsRollingStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Boolean> requestCacheEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Boolean> requestLogEnabled() {
        return this.requestLogEnabled;
    }
}

