/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;

final class AstrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private ConcurrentMap<HystrixThreadPoolKey, ThreadPoolExecutor> threadPoolByKey = new ConcurrentHashMap<HystrixThreadPoolKey, ThreadPoolExecutor>();

    AstrixConcurrencyStrategy() {
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return this.threadPoolByKey.computeIfAbsent(threadPoolKey, key -> super.getThreadPool(key, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue));
    }

    @PreDestroy
    public void destroy() {
        this.threadPoolByKey.values().stream().forEach(ThreadPoolExecutor::shutdownNow);
    }
}

