/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.config.BeanConfiguration;
import com.avanza.astrix.beans.core.AstrixBeanSettings;
import com.avanza.astrix.config.DynamicIntProperty;
import com.avanza.astrix.config.DynamicProperty;
import com.avanza.astrix.ft.hystrix.DynamicPropertyAdapter;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixProperty;

class AstrixThreadPoolProperties
extends HystrixThreadPoolProperties {
    static final AstrixBeanSettings.IntBeanSetting MAX_QUEUE_SIZE = new AstrixBeanSettings.IntBeanSetting("faultTolerance.queueSize", 1000000);
    private final HystrixProperty<Integer> queueSizeRejectionThreshold;
    private final HystrixProperty<Integer> coreSize;
    private final HystrixProperty<Integer> keepAliveTimeMinutes;
    private final HystrixProperty<Integer> maxQueueSize;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds;

    AstrixThreadPoolProperties(BeanConfiguration beanConfiguration, HystrixThreadPoolKey key, HystrixThreadPoolProperties.Setter builder) {
        super(key, builder);
        this.queueSizeRejectionThreshold = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(AstrixBeanSettings.QUEUE_SIZE_REJECTION_THRESHOLD));
        this.coreSize = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(AstrixBeanSettings.CORE_SIZE));
        this.keepAliveTimeMinutes = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)new DynamicIntProperty(1));
        this.maxQueueSize = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)beanConfiguration.get(MAX_QUEUE_SIZE));
        this.metricsRollingStatisticalWindowBuckets = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)new DynamicIntProperty(10));
        this.metricsRollingStatisticalWindowInMilliseconds = new DynamicPropertyAdapter<Integer>((DynamicProperty<Integer>)new DynamicIntProperty(10000));
    }

    public HystrixProperty<Integer> queueSizeRejectionThreshold() {
        return this.queueSizeRejectionThreshold;
    }

    public HystrixProperty<Integer> coreSize() {
        return this.coreSize;
    }

    public HystrixProperty<Integer> keepAliveTimeMinutes() {
        return this.keepAliveTimeMinutes;
    }

    public HystrixProperty<Integer> maxQueueSize() {
        return this.maxQueueSize;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.metricsRollingStatisticalWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.metricsRollingStatisticalWindowInMilliseconds;
    }
}

