/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.config.AstrixConfig;
import com.avanza.astrix.beans.config.BeanConfiguration;
import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.ft.hystrix.AstrixCommandProperties;
import com.avanza.astrix.ft.hystrix.AstrixThreadPoolProperties;
import com.avanza.astrix.ft.hystrix.BeanMapping;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.Optional;

final class BeanConfigurationPropertiesStrategy
extends HystrixPropertiesStrategy {
    private final BeanMapping beanMapping;
    private final AstrixConfig config;

    public BeanConfigurationPropertiesStrategy(AstrixConfig config, BeanMapping beanMapping) {
        this.config = config;
        this.beanMapping = beanMapping;
    }

    public HystrixCommandProperties getCommandProperties(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
        return this.beanMapping.getBeanKey(commandKey).flatMap(beanKey -> this.createCommandProperties((AstrixBeanKey<?>)beanKey, commandKey, builder)).orElse(super.getCommandProperties(commandKey, builder));
    }

    private Optional<HystrixCommandProperties> createCommandProperties(AstrixBeanKey<?> beanKey, HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
        return Optional.ofNullable(this.config.getBeanConfiguration(beanKey)).map(beanConfiguration -> new AstrixCommandProperties((BeanConfiguration)beanConfiguration, commandKey, builder));
    }

    public HystrixThreadPoolProperties getThreadPoolProperties(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
        return this.beanMapping.getBeanKey(threadPoolKey).flatMap(beanKey -> this.createThreadPoolProperties((AstrixBeanKey<?>)beanKey, threadPoolKey, builder)).orElse(super.getThreadPoolProperties(threadPoolKey, builder));
    }

    private Optional<HystrixThreadPoolProperties> createThreadPoolProperties(AstrixBeanKey<?> beanKey, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
        return Optional.ofNullable(this.config.getBeanConfiguration(beanKey)).map(beanConfiguration -> new AstrixThreadPoolProperties((BeanConfiguration)beanConfiguration, threadPoolKey, builder));
    }

    public HystrixCollapserProperties getCollapserProperties(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
        return super.getCollapserProperties(collapserKey, builder);
    }
}

