/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.ft.hystrix.BeanFaultToleranceMetricsMBean;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.Optional;

public class BeanFaultToleranceMetrics
implements BeanFaultToleranceMetricsMBean {
    private HystrixCommandKey key;
    private HystrixThreadPoolKey poolKey;

    public BeanFaultToleranceMetrics(HystrixCommandKey key, HystrixThreadPoolKey poolKey) {
        this.key = key;
        this.poolKey = poolKey;
    }

    @Override
    public long getErrorCount() {
        return this.getCommandHealthCounts().map(HystrixCommandMetrics.HealthCounts::getErrorCount).orElse(0L);
    }

    private Optional<HystrixCommandMetrics.HealthCounts> getCommandHealthCounts() {
        return this.getCommandMetrics().map(HystrixCommandMetrics::getHealthCounts);
    }

    private Optional<HystrixCommandMetrics> getCommandMetrics() {
        return Optional.ofNullable(HystrixCommandMetrics.getInstance((HystrixCommandKey)this.key));
    }

    @Override
    public int getErrorPercentage() {
        return this.getCommandHealthCounts().map(HystrixCommandMetrics.HealthCounts::getErrorPercentage).orElse(0);
    }

    @Override
    public int getCurrentConcurrentExecutionCount() {
        return this.getCommandMetrics().map(HystrixCommandMetrics::getCurrentConcurrentExecutionCount).orElse(0);
    }

    @Override
    public long getRollingMaxConcurrentExecutions() {
        return this.getCommandMetrics().map(HystrixCommandMetrics::getRollingMaxConcurrentExecutions).orElse(0L);
    }

    @Override
    public long getSuccessCount() {
        return this.getCommandMetrics().map(me -> me.getCumulativeCount(HystrixRollingNumberEvent.SUCCESS)).orElse(0L);
    }

    @Override
    public long getSemaphoreRejectedCount() {
        return this.getCommandMetrics().map(me -> me.getCumulativeCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED)).orElse(0L);
    }

    @Override
    public long getShortCircuitedCount() {
        return this.getCommandMetrics().map(me -> me.getCumulativeCount(HystrixRollingNumberEvent.SHORT_CIRCUITED)).orElse(0L);
    }

    @Override
    public long getTimeoutCount() {
        return this.getCommandMetrics().map(me -> me.getCumulativeCount(HystrixRollingNumberEvent.TIMEOUT)).orElse(0L);
    }

    @Override
    public long getThreadPoolRejectedCount() {
        return this.getCommandMetrics().map(me -> me.getCumulativeCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED)).orElse(0L);
    }

    @Override
    public int getPoolCurrentActiveCount() {
        return Optional.ofNullable(HystrixThreadPoolMetrics.getInstance((HystrixThreadPoolKey)this.poolKey)).map(HystrixThreadPoolMetrics::getCurrentActiveCount).map(Number::intValue).orElse(0);
    }

    @Override
    public int getPoolCurrentQueueCount() {
        return Optional.ofNullable(HystrixThreadPoolMetrics.getInstance((HystrixThreadPoolKey)this.poolKey)).map(HystrixThreadPoolMetrics::getCurrentQueueSize).map(Number::intValue).orElse(0);
    }

    @Override
    public int getPoolRollingMaxActiveThreads() {
        return Optional.ofNullable(HystrixThreadPoolMetrics.getInstance((HystrixThreadPoolKey)this.poolKey)).map(HystrixThreadPoolMetrics::getRollingMaxActiveThreads).map(Number::intValue).orElse(0);
    }

    @Override
    public int getIsCircuitBreakerOpen() {
        return Optional.ofNullable(HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)this.key)).map(cb -> cb.isOpen() ? 1 : 0).orElse(1);
    }

    @Override
    public int getLatencyExecute50() {
        return this.getCommandMetrics().map(m -> m.getExecutionTimePercentile(50.0)).orElse(0);
    }

    @Override
    public int getLatencyExecute90() {
        return this.getCommandMetrics().map(m -> m.getExecutionTimePercentile(90.0)).orElse(0);
    }

    @Override
    public int getLatencyExecute99() {
        return this.getCommandMetrics().map(m -> m.getExecutionTimePercentile(99.0)).orElse(0);
    }

    @Override
    public int getLatencyExecute100() {
        return this.getCommandMetrics().map(m -> m.getExecutionTimePercentile(100.0)).orElse(0);
    }

    @Override
    public int getPoolCurrentSize() {
        return Optional.ofNullable(HystrixThreadPoolMetrics.getInstance((HystrixThreadPoolKey)this.poolKey)).map(HystrixThreadPoolMetrics::getCurrentPoolSize).map(Number::intValue).orElse(0);
    }

    @Override
    public int getPoolQueueSizeRejectionThreshold() {
        return Optional.ofNullable(HystrixThreadPoolMetrics.getInstance((HystrixThreadPoolKey)this.poolKey)).map(HystrixThreadPoolMetrics::getProperties).map(HystrixThreadPoolProperties::queueSizeRejectionThreshold).map(HystrixProperty::get).orElse(0);
    }
}

