/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class BeanMapping {
    private final ConcurrentMap<String, AstrixBeanKey<?>> beanKeyByCommandName = new ConcurrentHashMap();

    BeanMapping() {
    }

    public Optional<AstrixBeanKey<?>> getBeanKey(HystrixCommandKey commandKey) {
        return Optional.ofNullable((AstrixBeanKey)this.beanKeyByCommandName.get(commandKey.name()));
    }

    public Optional<AstrixBeanKey<?>> getBeanKey(HystrixThreadPoolKey threadPoolKey) {
        return Optional.ofNullable((AstrixBeanKey)this.beanKeyByCommandName.get(threadPoolKey.name()));
    }

    public void registerBeanKey(String commandName, AstrixBeanKey<?> beanKey) {
        this.beanKeyByCommandName.putIfAbsent(commandName, beanKey);
    }
}

