/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.config.AstrixConfig;
import com.avanza.astrix.beans.config.BeanConfiguration;
import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.beans.core.AstrixBeanSettings;
import com.avanza.astrix.ft.hystrix.BeanMapping;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FailedServiceInvocationLogger
extends HystrixEventNotifier {
    private static final Logger log = LoggerFactory.getLogger(FailedServiceInvocationLogger.class);
    private final BeanMapping beanMapping;
    private final AstrixConfig astrixConfig;
    private final Map<AstrixBeanKey<?>, FailedBeanInvocationLogger> beanLoggerByBeanKey = new ConcurrentHashMap();

    public FailedServiceInvocationLogger(BeanMapping beanMapping, AstrixConfig config) {
        this.beanMapping = beanMapping;
        this.astrixConfig = config;
    }

    public void markEvent(HystrixEventType eventType, HystrixCommandKey key) {
        this.logEvent(eventType, key);
    }

    private void logEvent(HystrixEventType eventType, HystrixCommandKey commandKey) {
        this.getBeanInvocationLogger(commandKey).orElse(this.createNonBeanInvocationCommandLogger(commandKey)).accept(eventType);
    }

    private Consumer<HystrixEventType> createNonBeanInvocationCommandLogger(HystrixCommandKey key) {
        return eventType -> {
            switch (eventType) {
                case FAILURE: 
                case SEMAPHORE_REJECTED: 
                case THREAD_POOL_REJECTED: 
                case TIMEOUT: 
                case SHORT_CIRCUITED: {
                    log.info(String.format("Aborted command execution: cause=%s astrixBean=null hystrixCommandKey=%s", eventType, key.name()));
                    break;
                }
            }
        };
    }

    private Optional<Consumer<HystrixEventType>> getBeanInvocationLogger(HystrixCommandKey commandKey) {
        return this.beanMapping.getBeanKey(commandKey).map(beanKey -> this.getOrCreateBeanInvocationLogger(commandKey, (AstrixBeanKey<?>)beanKey));
    }

    private Consumer<HystrixEventType> getOrCreateBeanInvocationLogger(HystrixCommandKey commandKey, AstrixBeanKey<?> beanKey) {
        return this.beanLoggerByBeanKey.computeIfAbsent(beanKey, k -> this.createLogger(commandKey, beanKey));
    }

    private FailedBeanInvocationLogger createLogger(HystrixCommandKey commandKey, AstrixBeanKey<?> beanKey) {
        return new FailedBeanInvocationLogger(this.astrixConfig.getBeanConfiguration(beanKey), beanKey, commandKey);
    }

    private static final class FailedBeanInvocationLogger
    implements Consumer<HystrixEventType> {
        private final BeanConfiguration beanConfiguration;
        private final AstrixBeanKey<?> beanKey;
        private final HystrixCommandKey hystrixCommandKey;

        public FailedBeanInvocationLogger(BeanConfiguration beanConfiguration, AstrixBeanKey<?> beanKey, HystrixCommandKey hystrixCommandKey) {
            this.beanConfiguration = beanConfiguration;
            this.beanKey = beanKey;
            this.hystrixCommandKey = hystrixCommandKey;
        }

        @Override
        public void accept(HystrixEventType t) {
            this.logEvent(t);
        }

        private void logEvent(HystrixEventType eventType) {
            switch (eventType) {
                case FAILURE: {
                    log.info(String.format("Aborted command execution: cause=%s astrixBean=%s hystrixCommandKey=%s", eventType, this.beanKey, this.hystrixCommandKey.name()));
                    break;
                }
                case SEMAPHORE_REJECTED: {
                    this.logSemaphoreRejectedRequest(eventType);
                    break;
                }
                case THREAD_POOL_REJECTED: {
                    this.logThreadPoolRejectedRequest(eventType);
                    break;
                }
                case TIMEOUT: {
                    this.logTimeoutRequest(eventType);
                    break;
                }
                case SHORT_CIRCUITED: {
                    log.info(String.format("Aborted command execution: cause=%s astrixBean=%s hystrixCommandKey=%s", eventType, this.beanKey, this.hystrixCommandKey.name()));
                    break;
                }
            }
        }

        private void logTimeoutRequest(HystrixEventType eventType) {
            log.info(String.format("Aborted command execution: cause=%s astrixBean=%s hystrixCommandKey=%s TIMEOUT=%s [ms]", eventType, this.beanKey, this.hystrixCommandKey.name(), this.beanConfiguration.get(AstrixBeanSettings.TIMEOUT).get()));
        }

        private void logThreadPoolRejectedRequest(HystrixEventType eventType) {
            log.info(String.format("Aborted command execution: cause=%s astrixBean=%s hystrixCommandKey=%s CORE_SIZE=%s QUEUE_SIZE_REJECTION_THRESHOLD=%s", eventType, this.beanKey, this.hystrixCommandKey.name(), this.beanConfiguration.get(AstrixBeanSettings.CORE_SIZE).get(), this.beanConfiguration.get(AstrixBeanSettings.QUEUE_SIZE_REJECTION_THRESHOLD).get()));
        }

        private void logSemaphoreRejectedRequest(HystrixEventType eventType) {
            log.info(String.format("Aborted command execution: cause=%s astrixBean=%s hystrixCommandKey=%s MAX_CONCURRENT_REQUESTS=%s", eventType, this.beanKey, this.hystrixCommandKey.name(), this.beanConfiguration.get(AstrixBeanSettings.MAX_CONCURRENT_REQUESTS).get()));
        }
    }
}

