/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.async.ContextPropagation;
import com.avanza.astrix.core.AstrixCallStackTrace;
import com.avanza.astrix.core.ServiceUnavailableException;
import com.avanza.astrix.core.function.CheckedCommand;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HystrixCommandFacade<T> {
    private static final Logger log = LoggerFactory.getLogger(HystrixCommandFacade.class);
    private final CheckedCommand<T> command;
    private final HystrixCommand.Setter hystrixConfiguration;
    private final ContextPropagation contextPropagation;

    private HystrixCommandFacade(CheckedCommand<T> command, HystrixCommand.Setter hystrixConfiguration, ContextPropagation contextPropagation) {
        this.command = command;
        this.hystrixConfiguration = hystrixConfiguration;
        this.contextPropagation = Objects.requireNonNull(contextPropagation);
    }

    @Deprecated
    public static <T> T execute(CheckedCommand<T> command, HystrixCommand.Setter settings) throws Throwable {
        return HystrixCommandFacade.execute(command, settings, ContextPropagation.NONE);
    }

    public static <T> T execute(CheckedCommand<T> command, HystrixCommand.Setter settings, ContextPropagation contextPropagation) throws Throwable {
        return new HystrixCommandFacade<T>(command, settings, contextPropagation).execute();
    }

    protected T execute() throws Throwable {
        HystrixResult result;
        HystrixCommand<HystrixResult<T>> command = this.createHystrixCommand(this.contextPropagation);
        try {
            result = (HystrixResult)command.execute();
        }
        catch (HystrixRuntimeException e) {
            log.trace("Exception executing command", (Throwable)e);
            throw new ServiceUnavailableException(e.getFailureType().toString());
        }
        this.throwExceptionIfExecutionFailed(result);
        return result.getResult();
    }

    private void throwExceptionIfExecutionFailed(HystrixResult<T> result) throws Throwable {
        if (result.getException() != null) {
            AstrixCallStackTrace trace = new AstrixCallStackTrace();
            this.appendStackTrace(result.getException(), trace);
            throw result.getException();
        }
    }

    private void appendStackTrace(Throwable exception, AstrixCallStackTrace trace) {
        Throwable lastThowableInChain = exception;
        while (lastThowableInChain.getCause() != null) {
            lastThowableInChain = lastThowableInChain.getCause();
        }
        lastThowableInChain.initCause((Throwable)trace);
    }

    private HystrixCommand<HystrixResult<T>> createHystrixCommand(ContextPropagation contextPropagators) {
        final CheckedCommand wrappedCall = contextPropagators.wrap(this.command);
        return new HystrixCommand<HystrixResult<T>>(this.hystrixConfiguration){

            protected HystrixResult<T> run() throws Exception {
                try {
                    return HystrixResult.success(wrappedCall.call());
                }
                catch (Throwable e) {
                    return this.handleException(e);
                }
            }

            private HystrixResult<T> handleException(Throwable cause) {
                if (cause instanceof ServiceUnavailableException) {
                    throw (ServiceUnavailableException)cause;
                }
                return HystrixResult.exception(cause);
            }

            protected HystrixResult<T> getFallback() {
                String cause = this.resolveUnavailableCause();
                log.info(String.format("Aborted command execution: cause=%s circuit=%s", cause, this.getCommandKey().name()));
                if (this.isFailedExecution()) {
                    return HystrixResult.exception(this.getFailedExecutionException());
                }
                return HystrixResult.exception((Throwable)new ServiceUnavailableException(String.format("cause=%s service=%s executionTime=%s", Objects.toString(cause), this.getCommandKey().name(), this.getExecutionTimeInMilliseconds())));
            }

            private String resolveUnavailableCause() {
                if (this.isResponseRejected()) {
                    return "REJECTED_EXECUTION";
                }
                if (this.isResponseTimedOut()) {
                    return "TIMEOUT";
                }
                if (this.isResponseShortCircuited()) {
                    return "SHORT_CIRCUITED";
                }
                if (this.isFailedExecution()) {
                    return "UNAVAILABLE";
                }
                return "UNKNOWN";
            }
        };
    }

    private static class HystrixResult<T> {
        private T result;
        private Throwable exception;

        public static <T> HystrixResult<T> success(T result) {
            return new HystrixResult<T>(result, null);
        }

        public static <T> HystrixResult<T> exception(Throwable exception) {
            return new HystrixResult<Object>(null, exception);
        }

        public HystrixResult(T result, Throwable exception) {
            this.result = result;
            this.exception = exception;
        }

        public T getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

