/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.beans.ft.HystrixCommandNamingStrategy;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;

final class HystrixCommandKeyFactory {
    private String astrixContextId;
    private HystrixCommandNamingStrategy commandNamingStrategy;

    HystrixCommandKeyFactory(String astrixContextId, HystrixCommandNamingStrategy commandNamingStrategy) {
        this.astrixContextId = astrixContextId;
        this.commandNamingStrategy = commandNamingStrategy;
    }

    HystrixCommandKey createCommandKey(AstrixBeanKey<?> beanKey) {
        Object commandKeyName = this.commandNamingStrategy.getCommandKeyName(beanKey);
        if (!this.astrixContextId.equals("1")) {
            commandKeyName = (String)commandKeyName + "[" + this.astrixContextId + "]";
        }
        return HystrixCommandKey.Factory.asKey((String)commandKeyName);
    }

    HystrixCommandGroupKey createGroupKey(AstrixBeanKey<?> beanKey) {
        Object commandKeyName = this.commandNamingStrategy.getCommandKeyName(beanKey);
        if (!this.astrixContextId.equals("1")) {
            commandKeyName = (String)commandKeyName + "[" + this.astrixContextId + "]";
        }
        return HystrixCommandGroupKey.Factory.asKey((String)commandKeyName);
    }

    HystrixThreadPoolKey createThreadPoolKey(AstrixBeanKey<?> beanKey) {
        Object commandKeyName = this.commandNamingStrategy.getCommandKeyName(beanKey);
        if (!this.astrixContextId.equals("1")) {
            commandKeyName = (String)commandKeyName + "[" + this.astrixContextId + "]";
        }
        return HystrixThreadPoolKey.Factory.asKey((String)commandKeyName);
    }
}

