/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.beans.async.ContextPropagation;
import com.avanza.astrix.beans.config.AstrixConfig;
import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.beans.ft.BeanFaultTolerance;
import com.avanza.astrix.beans.ft.BeanFaultToleranceFactorySpi;
import com.avanza.astrix.beans.ft.HystrixCommandNamingStrategy;
import com.avanza.astrix.beans.ft.MonitorableFaultToleranceSpi;
import com.avanza.astrix.beans.tracing.AstrixTraceProvider;
import com.avanza.astrix.beans.tracing.DefaultTraceProvider;
import com.avanza.astrix.ft.hystrix.AstrixConcurrencyStrategy;
import com.avanza.astrix.ft.hystrix.BeanConfigurationPropertiesStrategy;
import com.avanza.astrix.ft.hystrix.BeanFaultToleranceMetrics;
import com.avanza.astrix.ft.hystrix.BeanFaultToleranceMetricsMBean;
import com.avanza.astrix.ft.hystrix.BeanMapping;
import com.avanza.astrix.ft.hystrix.FailedServiceInvocationLogger;
import com.avanza.astrix.ft.hystrix.HystrixBeanFaultTolerance;
import com.avanza.astrix.ft.hystrix.HystrixCommandKeyFactory;
import com.avanza.astrix.ft.hystrix.HystrixStrategies;
import com.avanza.astrix.ft.hystrix.HystrixStrategyDispatcher;
import com.avanza.astrix.modules.AstrixInject;
import com.avanza.hystrix.multiconfig.MultiConfigId;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HystrixFaultToleranceFactory
implements BeanFaultToleranceFactorySpi,
MonitorableFaultToleranceSpi {
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final BeanMapping beanMapping;
    private final HystrixCommandKeyFactory hystrixCommandKeyFactory;
    private final String id;
    private final ContextPropagation contextPropagation;
    private MultiConfigId multiConfigId = MultiConfigId.create((String)"astrix");

    @Deprecated
    public HystrixFaultToleranceFactory(HystrixCommandNamingStrategy hystrixCommandNamingStrategy, AstrixConcurrencyStrategy concurrencyStrategy, BeanConfigurationPropertiesStrategy propertiesStrategy, BeanMapping beanMapping, AstrixConfig config) {
        this(hystrixCommandNamingStrategy, concurrencyStrategy, propertiesStrategy, beanMapping, config, (AstrixTraceProvider)new DefaultTraceProvider());
    }

    @AstrixInject
    public HystrixFaultToleranceFactory(HystrixCommandNamingStrategy hystrixCommandNamingStrategy, AstrixConcurrencyStrategy concurrencyStrategy, BeanConfigurationPropertiesStrategy propertiesStrategy, BeanMapping beanMapping, AstrixConfig config, AstrixTraceProvider astrixTraceProvider) {
        this.id = Integer.toString(idGenerator.incrementAndGet());
        this.beanMapping = beanMapping;
        HystrixStrategies hystrixStrategies = new HystrixStrategies(propertiesStrategy, concurrencyStrategy, new FailedServiceInvocationLogger(beanMapping, config), this.id);
        HystrixStrategyDispatcher.registerStrategies(hystrixStrategies);
        this.hystrixCommandKeyFactory = new HystrixCommandKeyFactory(this.id, hystrixCommandNamingStrategy);
        this.contextPropagation = ContextPropagation.create((List)astrixTraceProvider.getContextPropagators());
    }

    public BeanFaultTolerance create(AstrixBeanKey<?> beanKey) {
        return new HystrixBeanFaultTolerance(this.getCommandKey(beanKey), this.getGroupKey(beanKey), this.contextPropagation);
    }

    public BeanFaultToleranceMetricsMBean createBeanFaultToleranceMetricsMBean(AstrixBeanKey<?> beanKey) {
        return new BeanFaultToleranceMetrics(this.getCommandKey(beanKey), this.getThreadPoolKey(beanKey));
    }

    HystrixCommandGroupKey getGroupKey(AstrixBeanKey<?> beanKey) {
        HystrixCommandGroupKey result = this.hystrixCommandKeyFactory.createGroupKey(beanKey);
        this.beanMapping.registerBeanKey(result.name(), beanKey);
        return this.multiConfigId.encode(result);
    }

    HystrixCommandKey getCommandKey(AstrixBeanKey<?> beanKey) {
        HystrixCommandKey result = this.hystrixCommandKeyFactory.createCommandKey(beanKey);
        this.beanMapping.registerBeanKey(result.name(), beanKey);
        return this.multiConfigId.encode(result);
    }

    HystrixThreadPoolKey getThreadPoolKey(AstrixBeanKey<?> beanKey) {
        HystrixThreadPoolKey result = this.hystrixCommandKeyFactory.createThreadPoolKey(beanKey);
        this.beanMapping.registerBeanKey(result.name(), beanKey);
        return this.multiConfigId.encode(result);
    }
}

