/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.core.ServiceUnavailableException;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.function.Supplier;
import rx.Observable;
import rx.functions.Func1;

class HystrixObservableCommandFacade<T> {
    HystrixObservableCommandFacade() {
    }

    public static <T> Observable<T> observe(final Supplier<Observable<T>> observableFactory, HystrixObservableCommand.Setter settings) {
        Observable faultToleranceProtectedObservable = new HystrixObservableCommand<Result<T>>(settings){

            protected Observable<Result<T>> construct() {
                return ((Observable)observableFactory.get()).map(new Func1<T, Result<T>>(){

                    public Result<T> call(T t1) {
                        return Result.success(t1);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends Result<T>>>(){

                    public Observable<? extends Result<T>> call(Throwable t1) {
                        if (t1 instanceof ServiceUnavailableException) {
                            return Observable.error((Throwable)t1);
                        }
                        return Observable.just(Result.exception(t1));
                    }
                });
            }

            protected Observable<Result<T>> resumeWithFallback() {
                return Observable.just(Result.exception((Throwable)this.createServiceUnavailableException()));
            }

            private ServiceUnavailableException createServiceUnavailableException() {
                if (this.isResponseRejected()) {
                    return new ServiceUnavailableException(String.format("cause=%s service=%s", "REJECTED_EXECUTION", this.getCommandKey().name()));
                }
                if (this.isResponseTimedOut()) {
                    return new ServiceUnavailableException(String.format("cause=%s service=%s executionTime=%s", "TIMEOUT", this.getCommandKey().name(), this.getExecutionTimeInMilliseconds()));
                }
                if (this.isResponseShortCircuited()) {
                    return new ServiceUnavailableException(String.format("cause=%s service=%s", "SHORT_CIRCUITED", this.getCommandKey().name()));
                }
                if (this.isFailedExecution() && this.getFailedExecutionException() instanceof ServiceUnavailableException) {
                    ServiceUnavailableException result = (ServiceUnavailableException)this.getFailedExecutionException();
                    HystrixObservableCommandFacade.appendStackTrace((Throwable)result, (Throwable)new ServiceUnavailableException(String.format("service=%s", this.getCommandKey().name())));
                    return result;
                }
                return new ServiceUnavailableException(String.format("cause=%s service=%s", "UNKNOWN", this.getCommandKey().name()));
            }
        }.observe();
        return faultToleranceProtectedObservable.flatMap(resultWrapper -> resultWrapper.toObservable()).onErrorResumeNext(error -> {
            if (error instanceof HystrixRuntimeException) {
                HystrixRuntimeException e = (HystrixRuntimeException)((Object)error);
                if (e.getCause() != null) {
                    return Observable.error((Throwable)e.getCause());
                }
                return Observable.error((Throwable)new ServiceUnavailableException(e.getFailureType().toString()));
            }
            return Observable.error((Throwable)error);
        });
    }

    private static void appendStackTrace(Throwable target, Throwable trace) {
        Throwable lastThowableInChain = target;
        while (lastThowableInChain.getCause() != null) {
            lastThowableInChain = lastThowableInChain.getCause();
        }
        lastThowableInChain.initCause(trace);
    }

    private static class Result<T> {
        private final T value;
        private final Throwable exception;

        public Result(T value, Throwable exception) {
            this.value = value;
            this.exception = exception;
        }

        public static <T> Result<T> success(T result) {
            return new Result<T>(result, null);
        }

        public static <T> Result<T> exception(Throwable throwable) {
            return new Result<Object>(null, throwable);
        }

        public Observable<T> toObservable() {
            if (this.exception != null) {
                return Observable.error((Throwable)this.exception);
            }
            return Observable.just(this.value);
        }
    }
}

