/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.ft.hystrix.ConcurrencyStrategyDispatcher;
import com.avanza.astrix.ft.hystrix.EventNotifierDispatcher;
import com.avanza.astrix.ft.hystrix.HystrixStrategies;
import com.avanza.astrix.ft.hystrix.HystrixStrategyMapping;
import com.avanza.astrix.ft.hystrix.PropertiesStrategyDispatcher;
import com.avanza.hystrix.multiconfig.MultiConfigs;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HystrixStrategyDispatcher {
    private static final Logger log = LoggerFactory.getLogger(HystrixStrategyDispatcher.class);
    private static final HystrixStrategyMapping strategyMapping = new HystrixStrategyMapping();

    HystrixStrategyDispatcher() {
    }

    static void registerStrategies(HystrixStrategies hystrixStrategies) {
        strategyMapping.registerStrategies(hystrixStrategies);
        HystrixStrategyDispatcher.verifyInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyInitialized() {
        Logger logger = log;
        synchronized (logger) {
            if (!MultiConfigs.containsAllMappings((String)"astrix")) {
                log.warn("Hystrix MultiConfig is not properly initialized. This means that the current Hystrix MultiConfig configuration was reset outside of Astrix. Astrix will reset Hystrix MultiConfig configuration and register custom Astrix stratgeis");
                HystrixStrategyDispatcher.registerDispatcherStrategies();
            }
            MultiConfigs.verifyRegistered();
        }
    }

    private static void initHystrixPlugins() {
        try {
            HystrixStrategyDispatcher.registerDispatcherStrategies();
        }
        catch (Exception e) {
            log.warn("Failed to init Hystrix with custom Astrix strategies. Hystrix configuration will be reset and one more registreation attempt will be performed", (Throwable)e);
            Hystrix.reset();
            HystrixStrategyDispatcher.registerDispatcherStrategies();
        }
    }

    private static void registerDispatcherStrategies() {
        MultiConfigs.register((String)"astrix", (HystrixPropertiesStrategy)new PropertiesStrategyDispatcher(strategyMapping));
        MultiConfigs.register((String)"astrix", (HystrixConcurrencyStrategy)new ConcurrencyStrategyDispatcher(strategyMapping));
        MultiConfigs.register((String)"astrix", (HystrixEventNotifier)new EventNotifierDispatcher(strategyMapping));
        log.info("Successfully initialized Hystrix MultiConfig with custom Astrix strategies");
    }

    static {
        HystrixStrategyDispatcher.initHystrixPlugins();
    }
}

