/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.ft.hystrix;

import com.avanza.astrix.ft.hystrix.HystrixStrategies;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HystrixStrategyMapping {
    private static Pattern pattern = Pattern.compile("\\[(\\d+)\\]$");
    private final Map<String, HystrixStrategies> strategiesById = new ConcurrentHashMap<String, HystrixStrategies>();

    HystrixStrategyMapping() {
    }

    private Optional<HystrixStrategies> getStrategies(String strategiesId) {
        return Optional.ofNullable(this.strategiesById.get(strategiesId));
    }

    void registerStrategies(HystrixStrategies strategies) {
        this.strategiesById.put(strategies.getId(), strategies);
    }

    HystrixStrategies getHystrixStrategies(HystrixCommandKey commandKey) {
        String contextId = this.parseStrategiesId(commandKey.name()).orElse("1");
        return this.getStrategies(contextId).orElseGet(HystrixStrategyMapping::getDefault);
    }

    HystrixStrategies getHystrixStrategies(HystrixThreadPoolKey commandKey) {
        String contextId = this.parseStrategiesId(commandKey.name()).orElse("1");
        return this.getStrategies(contextId).orElseGet(HystrixStrategyMapping::getDefault);
    }

    Optional<String> parseStrategiesId(String commandKey) {
        Matcher matcher = pattern.matcher(commandKey);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    static HystrixStrategies getDefault() {
        return new HystrixStrategies(HystrixPropertiesStrategyDefault.getInstance(), HystrixConcurrencyStrategyDefault.getInstance(), HystrixEventNotifierDefault.getInstance(), "default");
    }
}

