/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs;

import com.avanza.astrix.beans.async.ContextPropagation;
import com.avanza.astrix.beans.core.AstrixConfigAware;
import com.avanza.astrix.beans.service.ServiceProperties;
import com.avanza.astrix.beans.tracing.AstrixTraceProvider;
import com.avanza.astrix.beans.tracing.DefaultTraceProvider;
import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.gs.ClusteredProxyCache;
import com.avanza.astrix.gs.GigaspaceMetricsExporter;
import com.avanza.astrix.gs.GsBinder;
import com.avanza.astrix.gs.SpaceTaskDispatcher;
import com.avanza.astrix.gs.security.DefaultGsSecurityProvider;
import com.avanza.astrix.gs.security.GsSecurityProvider;
import com.avanza.astrix.modules.AstrixInject;
import com.avanza.astrix.modules.KeyLock;
import com.avanza.astrix.modules.ObjectCache;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.j_spaces.core.IJSpace;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredProxyCacheImpl
implements AstrixConfigAware,
ClusteredProxyCache {
    private static final Logger log = LoggerFactory.getLogger(ClusteredProxyCacheImpl.class);
    private final ObjectCache objectCache = new ObjectCache();
    private final KeyLock<String> proxyByUrlLock = new KeyLock();
    private final ContextPropagation contextPropagation;
    private final GsSecurityProvider gsSecurityProvider;
    private final GigaspaceMetricsExporter metricsExporter;
    private DynamicConfig config;

    @Deprecated
    public ClusteredProxyCacheImpl() {
        this((AstrixTraceProvider)new DefaultTraceProvider(), new DefaultGsSecurityProvider(), GigaspaceMetricsExporter.noExporter());
    }

    @AstrixInject
    public ClusteredProxyCacheImpl(AstrixTraceProvider astrixTraceProvider, GsSecurityProvider gsSecurityProvider, GigaspaceMetricsExporter metricsExporter) {
        this.contextPropagation = ContextPropagation.create((List)astrixTraceProvider.getContextPropagators());
        this.gsSecurityProvider = Objects.requireNonNull(gsSecurityProvider);
        this.metricsExporter = Objects.requireNonNull(metricsExporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GigaSpaceInstance getProxy(final ServiceProperties serviceProperties) {
        final String spaceUrl = GsBinder.getSpaceUrl(serviceProperties);
        this.proxyByUrlLock.lock((Object)spaceUrl);
        try {
            final String cacheKey = ClusteredProxyCacheImpl.getCacheKey(serviceProperties);
            GigaSpaceInstance spaceInstance = (GigaSpaceInstance)this.objectCache.getInstance((Object)cacheKey, (ObjectCache.ObjectFactory)new ObjectCache.ObjectFactory<GigaSpaceInstance>(){

                public GigaSpaceInstance create() {
                    log.info("Creating clustered proxy against: {}", (Object)spaceUrl);
                    GigaSpaceInstance gigaSpaceInstance = new GigaSpaceInstance(spaceUrl, cacheKey, ClusteredProxyCacheImpl.this.config, serviceProperties);
                    ClusteredProxyCacheImpl.this.metricsExporter.exportGigaspaceMetrics();
                    return gigaSpaceInstance;
                }
            });
            spaceInstance.incConsumerCount();
            GigaSpaceInstance gigaSpaceInstance = spaceInstance;
            return gigaSpaceInstance;
        }
        finally {
            this.proxyByUrlLock.unlock((Object)spaceUrl);
        }
    }

    @PreDestroy
    public void destroy() {
        this.objectCache.destroy();
    }

    ObjectCache getObjectCache() {
        return this.objectCache;
    }

    public void setConfig(DynamicConfig config) {
        this.config = config;
    }

    private CredentialsProvider getCredentialsProvider(String spaceName) {
        Object credentialsProvider = System.getProperties().get("com.gs.security.credentials-provider.class");
        if (credentialsProvider instanceof CredentialsProvider) {
            return (CredentialsProvider)credentialsProvider;
        }
        return this.gsSecurityProvider.getGsClientCredentialsProvider(spaceName);
    }

    private static String getCacheKey(ServiceProperties serviceProperties) {
        return GsBinder.getSpaceUrl(serviceProperties) + "&startTime=" + serviceProperties.getProperty("startTime");
    }

    public class GigaSpaceInstance {
        private final GigaSpace proxy;
        private final AtomicInteger proxyConsumerCount = new AtomicInteger(0);
        private final String spaceUrl;
        private final String cacheKey;
        private final UrlSpaceConfigurer urlSpaceConfigurer;
        @GuardedBy(value="spaceTaskDispatcherStateLock")
        private volatile SpaceTaskDispatcher spaceTaskDispatcher;
        private final Lock spaceTaskDispatcherStateLock = new ReentrantLock();
        private final DynamicConfig config;

        public GigaSpaceInstance(String spaceUrl, String cacheKey, DynamicConfig dynamicConfig, ServiceProperties serviceProperties) {
            this.spaceUrl = spaceUrl;
            this.cacheKey = cacheKey;
            this.config = dynamicConfig;
            this.urlSpaceConfigurer = new UrlSpaceConfigurer(spaceUrl);
            if (GsBinder.isAuthenticationRequired(serviceProperties)) {
                String spaceName = GsBinder.getSpaceName(serviceProperties);
                log.debug("Connecting to space {} as a secured space.", (Object)spaceName);
                this.urlSpaceConfigurer.credentialsProvider(ClusteredProxyCacheImpl.this.getCredentialsProvider(spaceName));
            }
            IJSpace space = this.urlSpaceConfigurer.create();
            this.proxy = new GigaSpaceConfigurer(space).create();
        }

        public void incConsumerCount() {
            this.proxyConsumerCount.incrementAndGet();
        }

        public GigaSpace get() {
            return this.proxy;
        }

        public SpaceTaskDispatcher getSpaceTaskDispatcher() {
            this.spaceTaskDispatcherStateLock.lock();
            try {
                if (this.spaceTaskDispatcher == null) {
                    this.spaceTaskDispatcher = new SpaceTaskDispatcher(this.proxy, this.config, ClusteredProxyCacheImpl.this.contextPropagation);
                }
                SpaceTaskDispatcher spaceTaskDispatcher = this.spaceTaskDispatcher;
                return spaceTaskDispatcher;
            }
            finally {
                this.spaceTaskDispatcherStateLock.unlock();
            }
        }

        public void release() {
            ClusteredProxyCacheImpl.this.proxyByUrlLock.lock((Object)this.spaceUrl);
            try {
                int consumerCount = this.proxyConsumerCount.decrementAndGet();
                if (consumerCount == 0) {
                    ClusteredProxyCacheImpl.this.objectCache.destroyInCache((Object)this.cacheKey);
                }
            }
            finally {
                ClusteredProxyCacheImpl.this.proxyByUrlLock.unlock((Object)this.spaceUrl);
            }
        }

        @PreDestroy
        public void destroy() throws Exception {
            log.info("Destroying clustered proxy against: {}", (Object)this.spaceUrl);
            if (this.spaceTaskDispatcher != null) {
                this.spaceTaskDispatcher.destroy();
            }
            this.urlSpaceConfigurer.close();
        }
    }
}

