/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs;

import com.avanza.astrix.beans.core.AstrixConfigAware;
import com.avanza.astrix.beans.core.AstrixSettings;
import com.avanza.astrix.config.DynamicBooleanProperty;
import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.context.mbeans.MBeanExporter;
import com.avanza.astrix.gs.GigaspaceMetricsExporter;
import com.avanza.astrix.gs.metrics.GigaspaceMetrics;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class GigaspaceMetricsExporterImpl
implements AstrixConfigAware,
GigaspaceMetricsExporter {
    private static final String MBEAN_FOLDER = "Gigaspaces";
    private static final String MBEAN_NAME = "Metrics";
    private final AtomicBoolean exported = new AtomicBoolean(false);
    private final MBeanExporter mBeanExporter;
    private DynamicBooleanProperty exportGigaspaceMetrics;

    GigaspaceMetricsExporterImpl(MBeanExporter mBeanExporter) {
        this.mBeanExporter = Objects.requireNonNull(mBeanExporter);
    }

    public void setConfig(DynamicConfig config) {
        this.exportGigaspaceMetrics = AstrixSettings.EXPORTED_GIGASPACE_METRICS_ENABLED.getFrom(config);
        this.exportGigaspaceMetrics.addListener(this::toggleMBean);
    }

    @Override
    public void exportGigaspaceMetrics() {
        this.toggleMBean(this.exportGigaspaceMetrics.get());
    }

    private void toggleMBean(boolean enableMBean) {
        if (enableMBean) {
            if (this.exported.compareAndSet(false, true)) {
                this.mBeanExporter.registerMBean((Object)new GigaspaceMetrics(), MBEAN_FOLDER, MBEAN_NAME);
            }
        } else if (this.exported.compareAndSet(true, false)) {
            this.mBeanExporter.unregisterMBean(MBEAN_FOLDER, MBEAN_NAME);
        }
    }
}

