/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs;

import com.avanza.astrix.beans.service.BoundServiceBeanInstance;
import com.avanza.astrix.beans.service.ServiceComponent;
import com.avanza.astrix.beans.service.ServiceDefinition;
import com.avanza.astrix.beans.service.ServiceProperties;
import com.avanza.astrix.beans.service.UnsupportedTargetTypeException;
import com.avanza.astrix.gs.BoundProxyServiceBeanInstance;
import com.avanza.astrix.gs.ClusteredProxyBinder;
import com.avanza.astrix.gs.ClusteredProxyCache;
import com.avanza.astrix.gs.ClusteredProxyCacheImpl;
import com.avanza.astrix.gs.GigaSpaceProxy;
import com.avanza.astrix.gs.GsBinder;
import com.avanza.astrix.gs.security.GsSecurityManager;
import com.avanza.astrix.gs.security.GsSecurityProvider;
import com.avanza.astrix.spring.AstrixSpringContext;
import org.openspaces.core.GigaSpace;

public class GsComponent
implements ServiceComponent,
ClusteredProxyBinder {
    private GsBinder gsBinder;
    private AstrixSpringContext astrixSpringContext;
    private ClusteredProxyCache proxyCache;

    public GsComponent(GsBinder gsBinder, AstrixSpringContext astrixSpringContext, ClusteredProxyCache proxyCache, GsSecurityProvider gsSecurityProvider) {
        this.gsBinder = gsBinder;
        this.astrixSpringContext = astrixSpringContext;
        this.proxyCache = proxyCache;
        GsSecurityManager.setGsServerAuthenticator(gsSecurityProvider.getGsServerAuthenticator());
    }

    @Override
    public <T> BoundServiceBeanInstance<T> bind(ServiceDefinition<T> serviceDefinition, ServiceProperties serviceProperties) {
        Class targetType = serviceDefinition.getServiceType();
        if (!GigaSpace.class.isAssignableFrom(targetType)) {
            throw new UnsupportedTargetTypeException(this.getName(), targetType);
        }
        ClusteredProxyCacheImpl.GigaSpaceInstance gigaSpaceInstance = this.proxyCache.getProxy(serviceProperties);
        Object proxyWithFaultTolerance = targetType.cast(GigaSpaceProxy.create(gigaSpaceInstance.get()));
        return BoundProxyServiceBeanInstance.create(proxyWithFaultTolerance, gigaSpaceInstance);
    }

    public ServiceProperties parseServiceProviderUri(String serviceProviderUri) {
        return this.gsBinder.createServiceProperties(serviceProviderUri);
    }

    public String getName() {
        return "gs";
    }

    public boolean canBindType(Class<?> type) {
        return GigaSpace.class.equals(type);
    }

    public <T> void exportService(Class<T> providedApi, T provider, ServiceDefinition<T> versioningContext) {
    }

    public boolean requiresProviderInstance() {
        return false;
    }

    public <T> ServiceProperties createServiceProperties(ServiceDefinition<T> definition) {
        if (!definition.getServiceType().equals(GigaSpace.class)) {
            throw new IllegalArgumentException("Can't export: " + definition.getServiceType());
        }
        GigaSpace space = this.gsBinder.getEmbeddedSpace(this.astrixSpringContext.getApplicationContext());
        return this.gsBinder.createProperties(space);
    }
}

