/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs.localview;

import com.avanza.astrix.beans.core.AstrixConfigAware;
import com.avanza.astrix.beans.core.AstrixSettings;
import com.avanza.astrix.beans.core.BeanProxy;
import com.avanza.astrix.beans.core.BeanProxyFilter;
import com.avanza.astrix.beans.service.BoundServiceBeanInstance;
import com.avanza.astrix.beans.service.ServiceComponent;
import com.avanza.astrix.beans.service.ServiceDefinition;
import com.avanza.astrix.beans.service.ServiceProperties;
import com.avanza.astrix.beans.service.UnsupportedTargetTypeException;
import com.avanza.astrix.config.DynamicBooleanProperty;
import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.config.DynamicIntProperty;
import com.avanza.astrix.config.DynamicLongProperty;
import com.avanza.astrix.core.util.ReflectionUtil;
import com.avanza.astrix.gs.ClusteredProxyBinder;
import com.avanza.astrix.gs.GigaSpaceProxy;
import com.avanza.astrix.gs.GigaspaceMetricsExporter;
import com.avanza.astrix.gs.GsBinder;
import com.avanza.astrix.gs.localview.LocalViewConfigurer;
import com.avanza.astrix.gs.localview.LocalViewSpaceConfigurerAdapter;
import com.avanza.astrix.spring.AstrixSpringContext;
import com.j_spaces.core.IJSpace;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.openspaces.core.space.cache.LocalViewSpaceConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsLocalViewComponent
implements ServiceComponent,
AstrixConfigAware,
BeanProxyFilter {
    private static final Logger log = LoggerFactory.getLogger(GsLocalViewComponent.class);
    private final GsBinder gsBinder;
    private final AstrixSpringContext astrixSpringContext;
    private final ClusteredProxyBinder clusteredProxyBinder;
    private final GigaspaceMetricsExporter metricsExporter;
    private DynamicBooleanProperty disableLocalView;
    private DynamicLongProperty maxDisonnectionTime;
    private DynamicIntProperty lookupTimeout;

    public GsLocalViewComponent(GsBinder gsBinder, AstrixSpringContext astrixSpringContext, ClusteredProxyBinder clusteredProxyBinder, GigaspaceMetricsExporter metricsExporter) {
        this.gsBinder = gsBinder;
        this.astrixSpringContext = astrixSpringContext;
        this.clusteredProxyBinder = clusteredProxyBinder;
        this.metricsExporter = metricsExporter;
    }

    public <T> BoundServiceBeanInstance<T> bind(ServiceDefinition<T> serviceDefinition, ServiceProperties serviceProperties) {
        Class type = serviceDefinition.getServiceType();
        if (!GigaSpace.class.isAssignableFrom(type)) {
            throw new UnsupportedTargetTypeException(this.getName(), type);
        }
        if (this.disableLocalView.get()) {
            log.info("LocalView is disabled. Creating reqular proxy");
            return this.clusteredProxyBinder.bind(serviceDefinition, serviceProperties);
        }
        log.info("Creating local view. bean={} serviceProperties={}", (Object)serviceDefinition.getBeanKey(), (Object)serviceProperties.getProperties());
        Class serviceConfigClass = serviceDefinition.getServiceConfigClass(LocalViewConfigurer.class);
        LocalViewConfigurer localViewConfigurer = (LocalViewConfigurer)ReflectionUtil.newInstance((Class)serviceConfigClass);
        UrlSpaceConfigurer gsSpaceConfigurer = new UrlSpaceConfigurer(serviceProperties.getProperty("spaceUrl"));
        IJSpace space = gsSpaceConfigurer.lookupTimeout(this.lookupTimeout.get()).addParameter("space-config.engine.memory_usage.enabled", "false").create();
        LocalViewSpaceConfigurer gslocalViewSpaceConfigurer = new LocalViewSpaceConfigurer(space);
        gslocalViewSpaceConfigurer.maxDisconnectionDuration(this.maxDisonnectionTime.get());
        localViewConfigurer.configure(new LocalViewSpaceConfigurerAdapter(gslocalViewSpaceConfigurer));
        String spaceName = serviceProperties.getProperty("spaceName");
        String commandKey = spaceName + "_" + GigaSpace.class.getSimpleName();
        String qualifier = serviceProperties.getProperty("_qualifier");
        if (qualifier != null) {
            commandKey = commandKey + "-" + qualifier;
        }
        IJSpace localViewSpace = gslocalViewSpaceConfigurer.create();
        GigaSpace localViewGigaSpace = GigaSpaceProxy.create(new GigaSpaceConfigurer(localViewSpace).create());
        this.metricsExporter.exportGigaspaceMetrics();
        BoundLocalViewGigaSpaceBeanInstance localViewGigaSpaceBeanInstance = new BoundLocalViewGigaSpaceBeanInstance(localViewGigaSpace, gslocalViewSpaceConfigurer, gsSpaceConfigurer);
        return localViewGigaSpaceBeanInstance;
    }

    public boolean applyBeanProxy(BeanProxy beanProxy) {
        if (beanProxy.name().equals("faultTolerance")) {
            return this.disableLocalView.get();
        }
        return true;
    }

    public ServiceProperties parseServiceProviderUri(String serviceProviderUri) {
        return this.gsBinder.createServiceProperties(serviceProviderUri);
    }

    public <T> ServiceProperties createServiceProperties(ServiceDefinition<T> definition) {
        if (!definition.getServiceType().equals(GigaSpace.class)) {
            throw new UnsupportedTargetTypeException(this.getName(), definition.getServiceType());
        }
        GigaSpace space = this.gsBinder.getEmbeddedSpace(this.astrixSpringContext.getApplicationContext());
        ServiceProperties properties = this.gsBinder.createProperties(space);
        return properties;
    }

    public String getName() {
        return "gs-local-view";
    }

    public boolean canBindType(Class<?> type) {
        return GigaSpace.class.equals(type);
    }

    public <T> void exportService(Class<T> providedApi, T provider, ServiceDefinition<T> serviceDefintition) {
    }

    public boolean requiresProviderInstance() {
        return false;
    }

    public void setConfig(DynamicConfig config) {
        this.disableLocalView = AstrixSettings.GS_DISABLE_LOCAL_VIEW.getFrom(config);
        this.maxDisonnectionTime = AstrixSettings.GS_LOCAL_VIEW_MAX_DISCONNECTION_TIME.getFrom(config);
        this.lookupTimeout = AstrixSettings.GS_LOCAL_VIEW_LOOKUP_TIMEOUT.getFrom(config);
    }

    private static class BoundLocalViewGigaSpaceBeanInstance
    implements BoundServiceBeanInstance<GigaSpace> {
        private final GigaSpace instance;
        private final LocalViewSpaceConfigurer localViewSpaceConfigurer;
        private final UrlSpaceConfigurer spaceConfigurer;

        public BoundLocalViewGigaSpaceBeanInstance(GigaSpace instance, LocalViewSpaceConfigurer localViewSpaceConfigurer, UrlSpaceConfigurer spaceConfigurer) {
            this.instance = instance;
            this.localViewSpaceConfigurer = localViewSpaceConfigurer;
            this.spaceConfigurer = spaceConfigurer;
        }

        public GigaSpace get() {
            return this.instance;
        }

        public void release() {
            try {
                this.localViewSpaceConfigurer.close();
                this.spaceConfigurer.close();
            }
            catch (Exception e) {
                log.error("Failed to destroy local-view", (Throwable)e);
            }
        }
    }
}

