/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs.remoting;

import com.avanza.astrix.beans.core.ReactiveTypeConverter;
import com.avanza.astrix.beans.service.BoundServiceBeanInstance;
import com.avanza.astrix.beans.service.ServiceComponent;
import com.avanza.astrix.beans.service.ServiceDefinition;
import com.avanza.astrix.beans.service.ServiceProperties;
import com.avanza.astrix.beans.tracing.AstrixTraceProvider;
import com.avanza.astrix.beans.tracing.DefaultTraceProvider;
import com.avanza.astrix.core.remoting.RoutingStrategy;
import com.avanza.astrix.core.util.ReflectionUtil;
import com.avanza.astrix.gs.BoundProxyServiceBeanInstance;
import com.avanza.astrix.gs.ClusteredProxyCache;
import com.avanza.astrix.gs.ClusteredProxyCacheImpl;
import com.avanza.astrix.gs.GsBinder;
import com.avanza.astrix.gs.remoting.GsRemotingTransport;
import com.avanza.astrix.gs.remoting.GsRoutingStrategy;
import com.avanza.astrix.modules.AstrixInject;
import com.avanza.astrix.remoting.client.RemotingProxy;
import com.avanza.astrix.remoting.client.RemotingTransport;
import com.avanza.astrix.remoting.client.RemotingTransportSpi;
import com.avanza.astrix.remoting.server.AstrixServiceActivator;
import com.avanza.astrix.spring.AstrixSpringContext;
import com.avanza.astrix.versioning.core.AstrixObjectSerializer;
import com.avanza.astrix.versioning.core.ObjectSerializerFactory;
import java.util.Objects;
import org.openspaces.core.GigaSpace;

public class GsRemotingComponent
implements ServiceComponent {
    private final GsBinder gsBinder;
    private final AstrixSpringContext astrixSpringContext;
    private final AstrixServiceActivator serviceActivator;
    private final ObjectSerializerFactory objectSerializerFactory;
    private final ClusteredProxyCache proxyCache;
    private final ReactiveTypeConverter reactiveTypeConverter;
    private final AstrixTraceProvider astrixTraceProvider;

    @Deprecated
    public GsRemotingComponent(GsBinder gsBinder, AstrixSpringContext astrixSpringContext, AstrixServiceActivator serviceActivator, ObjectSerializerFactory objectSerializerFactory, ClusteredProxyCache proxyCache, ReactiveTypeConverter reactiveTypeConverter) {
        this(gsBinder, astrixSpringContext, serviceActivator, objectSerializerFactory, proxyCache, reactiveTypeConverter, (AstrixTraceProvider)new DefaultTraceProvider());
    }

    @AstrixInject
    public GsRemotingComponent(GsBinder gsBinder, AstrixSpringContext astrixSpringContext, AstrixServiceActivator serviceActivator, ObjectSerializerFactory objectSerializerFactory, ClusteredProxyCache proxyCache, ReactiveTypeConverter reactiveTypeConverter, AstrixTraceProvider astrixTraceProvider) {
        this.gsBinder = gsBinder;
        this.astrixSpringContext = astrixSpringContext;
        this.serviceActivator = serviceActivator;
        this.objectSerializerFactory = objectSerializerFactory;
        this.proxyCache = proxyCache;
        this.reactiveTypeConverter = reactiveTypeConverter;
        this.astrixTraceProvider = Objects.requireNonNull(astrixTraceProvider);
    }

    public <T> BoundServiceBeanInstance<T> bind(ServiceDefinition<T> serviceDefinition, ServiceProperties serviceProperties) {
        AstrixObjectSerializer objectSerializer = this.objectSerializerFactory.create(serviceDefinition.getObjectSerializerDefinition());
        ClusteredProxyCacheImpl.GigaSpaceInstance proxyInstance = this.proxyCache.getProxy(serviceProperties);
        GsRemotingTransport gsRemotingTransport = new GsRemotingTransport(proxyInstance.getSpaceTaskDispatcher());
        RemotingTransport remotingTransport = RemotingTransport.create((RemotingTransportSpi)gsRemotingTransport);
        Object proxy = RemotingProxy.create((Class)serviceDefinition.getServiceType(), (Class)ReflectionUtil.classForName((String)serviceProperties.getProperty("_api")), (RemotingTransport)remotingTransport, (AstrixObjectSerializer)objectSerializer, (RoutingStrategy)new GsRoutingStrategy(), (ReactiveTypeConverter)this.reactiveTypeConverter, (AstrixTraceProvider)this.astrixTraceProvider);
        return BoundProxyServiceBeanInstance.create(proxy, proxyInstance);
    }

    public ServiceProperties parseServiceProviderUri(String serviceProviderUri) {
        return this.gsBinder.createServiceProperties(serviceProviderUri);
    }

    public <T> ServiceProperties createServiceProperties(ServiceDefinition<T> serviceDefinition) {
        GigaSpace space = this.gsBinder.getEmbeddedSpace(this.astrixSpringContext.getApplicationContext());
        ServiceProperties serviceProperties = this.gsBinder.createProperties(space);
        return serviceProperties;
    }

    public String getName() {
        return "gs-remoting";
    }

    public boolean canBindType(Class<?> type) {
        return true;
    }

    public <T> void exportService(Class<T> providedApi, T provider, ServiceDefinition<T> serviceDefinition) {
        AstrixObjectSerializer objectSerializer = this.objectSerializerFactory.create(serviceDefinition.getObjectSerializerDefinition());
        this.serviceActivator.register(provider, objectSerializer, providedApi);
    }

    public boolean requiresProviderInstance() {
        return true;
    }
}

