/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs.remoting;

import com.avanza.astrix.core.AstrixBroadcast;
import com.avanza.astrix.core.remoting.Router;
import com.avanza.astrix.core.remoting.RoutingStrategy;
import com.avanza.astrix.remoting.client.AmbiguousRoutingException;
import com.avanza.astrix.remoting.client.AnnotatedArgumentInstanceRouter;
import com.avanza.astrix.remoting.client.AnnotatedArgumentRouter;
import com.avanza.astrix.remoting.client.BroadcastRouter;
import com.avanza.astrix.remoting.client.DefaultAstrixRoutingStrategy;
import com.avanza.astrix.remoting.client.PropertyOnAnnotatedArgumentRoutingStrategy;
import com.avanza.astrix.remoting.util.RoutingKeyMethodCache;
import com.gigaspaces.annotation.pojo.SpaceRouting;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.openspaces.remoting.Routing;

public class GsRoutingStrategy
implements RoutingStrategy {
    private static final RoutingKeyMethodCache<SpaceRouting> routingKeyMethodCache = new RoutingKeyMethodCache(SpaceRouting.class);

    public Router create(Method serviceMethod) {
        return this.createRoutingStrategy(serviceMethod);
    }

    private Router createRoutingStrategy(Method m) {
        Router result = new DefaultAstrixRoutingStrategy().create(m);
        if (result != null) {
            return result;
        }
        result = GsRoutingStrategy.lookForRoutingAnnotationInMethodSignature(m);
        if (result != null) {
            return result;
        }
        result = this.lookForRoutingAnnotationOnMethodArguments(m);
        if (result != null) {
            return result;
        }
        if (m.getAnnotation(AstrixBroadcast.class) == null) {
            throw new AmbiguousRoutingException(String.format("Ambiguous routing. No routing argument defined in method signature or on method arguments and method not annotated with @AstrixBroadcast. serviceMethod=%s", m.toString()));
        }
        return new BroadcastRouter();
    }

    private Router lookForRoutingAnnotationOnMethodArguments(Method m) {
        AnnotatedArgumentInstanceRouter result = null;
        for (int argumentIndex = 0; argumentIndex < m.getParameterTypes().length; ++argumentIndex) {
            Method routingKeyMethod = routingKeyMethodCache.getRoutingKeyMethod(m.getParameterTypes()[argumentIndex]);
            if (routingKeyMethod == null) continue;
            if (result != null) {
                throw new AmbiguousRoutingException(String.format("Ambiguous routing, multiple arguments with @SpaceRouting annotated methods. Use @Routing on one service argument to identify routing method, or @AstrixBroadcast for broadcast operations. service method=%s", m.toString()));
            }
            result = new AnnotatedArgumentInstanceRouter(argumentIndex, routingKeyMethod);
        }
        return result;
    }

    public static Router lookForRoutingAnnotationInMethodSignature(Method m) {
        Router routingStrategy = null;
        for (int argumentIndex = 0; argumentIndex < m.getParameterTypes().length; ++argumentIndex) {
            for (Annotation a : m.getParameterAnnotations()[argumentIndex]) {
                if (!a.annotationType().equals(Routing.class)) continue;
                if (routingStrategy != null) {
                    throw new AmbiguousRoutingException(String.format("Ambiguous routing, multiple @Routing annotated methods on %s", m.toString()));
                }
                routingStrategy = GsRoutingStrategy.createRoutingStrategy(m, argumentIndex, (Routing)a);
            }
        }
        return routingStrategy;
    }

    public static Router createRoutingStrategy(Method serviceMethod, int routingArgumentIndex, Routing routingAnnotation) {
        if (routingAnnotation.value().trim().isEmpty()) {
            return new AnnotatedArgumentRouter(routingArgumentIndex);
        }
        String targetRoutingMethod = routingAnnotation.value();
        try {
            Class<?> type = serviceMethod.getParameterTypes()[routingArgumentIndex];
            Method method = type.getMethod(targetRoutingMethod, new Class[0]);
            return new PropertyOnAnnotatedArgumentRoutingStrategy(routingArgumentIndex, method);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Cant route using: " + targetRoutingMethod, e);
        }
    }
}

