/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.gs.security;

import com.avanza.astrix.gs.security.GsSecurityProvider;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.UserDetails;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsSecurityManager
implements SecurityManager {
    private static final Logger LOG = LoggerFactory.getLogger(GsSecurityManager.class);
    private static GsSecurityProvider.GsServerAuthenticator authenticator;

    public GsSecurityManager() {
        LOG.info("Created security manager");
    }

    public static void setGsServerAuthenticator(GsSecurityProvider.GsServerAuthenticator authenticator) {
        GsSecurityManager.authenticator = Objects.requireNonNull(authenticator);
        LOG.info("GsSecurityManager has been initialized with " + authenticator.getClass().getName());
    }

    public void init(Properties properties) throws SecurityException {
    }

    public Authentication authenticate(UserDetails userDetails) throws AuthenticationException {
        if (authenticator == null) {
            throw new AuthenticationException("GsSecurityManager is not initialized");
        }
        LOG.info("Authenticating user={}", (Object)userDetails.getUsername());
        return authenticator.authenticate(userDetails);
    }

    public DirectoryManager createDirectoryManager(UserDetails userDetails) throws AuthenticationException, AccessDeniedException {
        throw new UnsupportedOperationException("DirectoryManager not supported by GsSecurityManager");
    }

    public void close() {
    }
}

