/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.metrics;

import com.avanza.astrix.context.metrics.MetricsSpi;
import com.avanza.astrix.context.metrics.TimerSnaphot;
import com.avanza.astrix.context.metrics.TimerSpi;
import com.avanza.astrix.core.function.CheckedCommand;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import rx.Observable;

final class AstrixMetricsImpl
implements MetricsSpi {
    private final AtomicInteger nextTimerId = new AtomicInteger(0);
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    AstrixMetricsImpl() {
    }

    public TimerSpi createTimer() {
        return new TimerAdapter(Timer.builder((String)("astrix.timer-" + this.nextTimerId.incrementAndGet())).publishPercentiles(new double[]{0.0, 0.5, 0.9, 0.99}).register(this.meterRegistry));
    }

    static class TimerAdapter
    implements TimerSpi {
        private final Timer timer;

        public TimerAdapter(Timer timer) {
            this.timer = timer;
        }

        public <T> CheckedCommand<T> timeExecution(CheckedCommand<T> execution) {
            return () -> {
                Timer.Sample timerSample = Timer.start();
                try {
                    Object object = execution.call();
                    return object;
                }
                finally {
                    timerSample.stop(this.timer);
                }
            };
        }

        public <T> Supplier<Observable<T>> timeObservable(Supplier<Observable<T>> observableFactory) {
            return () -> {
                Timer.Sample timerSample = Timer.start();
                return ((Observable)observableFactory.get()).doOnTerminate(() -> timerSample.stop(this.timer));
            };
        }

        public TimerSnaphot getSnapshot() {
            TimeUnit durationUnit = TimeUnit.MILLISECONDS;
            HistogramSnapshot snapshot = this.timer.takeSnapshot();
            return TimerSnaphot.builder().count(snapshot.count()).maxLatency(snapshot.max(durationUnit)).minLatency(this.getPercentile(snapshot, durationUnit, 0.0)).set50thPercentileLatency(this.getPercentile(snapshot, durationUnit, 0.5)).set90thPercentileLatency(this.getPercentile(snapshot, durationUnit, 0.9)).set99thPercentileLatency(this.getPercentile(snapshot, durationUnit, 0.99)).durationUnit(durationUnit).build();
        }

        private double getPercentile(HistogramSnapshot snapshot, TimeUnit unit, double percentile) {
            for (ValueAtPercentile v : snapshot.percentileValues()) {
                if (v.percentile() != percentile) continue;
                return v.value(unit);
            }
            return 0.0;
        }
    }
}

