/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.service.registry.pu;

import com.avanza.astrix.beans.registry.AstrixServiceRegistryEntry;
import com.avanza.astrix.beans.registry.ServiceKey;
import com.avanza.astrix.beans.registry.ServiceProviderKey;
import com.avanza.astrix.beans.registry.ServiceRegistryEntryRepository;
import com.avanza.astrix.service.registry.pu.SpaceServiceRegistryEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.openspaces.core.GigaSpace;
import org.springframework.beans.factory.annotation.Autowired;

public class SpaceServiceRegistryEntryRepository
implements ServiceRegistryEntryRepository {
    private final GigaSpace gigaSpace;

    @Autowired
    public SpaceServiceRegistryEntryRepository(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void insertOrUpdate(AstrixServiceRegistryEntry entry, long lease) {
        SpaceServiceRegistryEntry spaceEntry = new SpaceServiceRegistryEntry();
        spaceEntry.setApiType(entry.getServiceBeanType());
        ServiceKey serviceKey = new ServiceKey(entry.getServiceBeanType(), (String)entry.getServiceProperties().get("_qualifier"));
        spaceEntry.setServiceKey(serviceKey);
        String applicationInstanceId = (String)entry.getServiceProperties().get("_applicationInstanceId");
        ServiceProviderKey serviceProviderKey = ServiceProviderKey.create((ServiceKey)serviceKey, (String)applicationInstanceId);
        spaceEntry.setServiceProviderKey(serviceProviderKey);
        spaceEntry.setProperties(entry.getServiceProperties());
        this.setLatestStartTime(spaceEntry);
        HashMap<String, String> metadata = new HashMap<String, String>();
        Date now = new Date();
        metadata.put("lastLeaseRenewalTime", now.toString());
        metadata.put("leaseExpireTime", new Date(now.getTime() + lease).toString());
        spaceEntry.setServiceMetadata(metadata);
        this.gigaSpace.write((Object)spaceEntry, lease);
    }

    private void setLatestStartTime(SpaceServiceRegistryEntry spaceEntry) {
        SpaceServiceRegistryEntry existingEntry = (SpaceServiceRegistryEntry)this.gigaSpace.readById(SpaceServiceRegistryEntry.class, (Object)spaceEntry.getServiceProviderKey(), (Object)spaceEntry.getApiType());
        if (existingEntry == null) {
            return;
        }
        long startTimeExistingEntry = this.getStartTime(existingEntry);
        long startTimeNewEntry = this.getStartTime(spaceEntry);
        spaceEntry.getProperties().put("startTime", Long.toString(Math.max(startTimeExistingEntry, startTimeNewEntry)));
    }

    private long getStartTime(SpaceServiceRegistryEntry entry) {
        return Optional.ofNullable(entry.getProperties()).map(p -> (String)p.get("startTime")).map(Long::parseLong).orElse(0L);
    }

    public List<AstrixServiceRegistryEntry> findAll() {
        SpaceServiceRegistryEntry[] entries = (SpaceServiceRegistryEntry[])this.gigaSpace.readMultiple((Object)SpaceServiceRegistryEntry.template());
        ArrayList<AstrixServiceRegistryEntry> result = new ArrayList<AstrixServiceRegistryEntry>();
        for (SpaceServiceRegistryEntry spaceEntry : entries) {
            AstrixServiceRegistryEntry entry = new AstrixServiceRegistryEntry();
            entry.setServiceBeanType(spaceEntry.getApiType());
            entry.setServiceProperties(spaceEntry.getProperties());
            entry.setServiceMetadata(spaceEntry.getServiceMetadata());
            result.add(entry);
        }
        return result;
    }

    public List<AstrixServiceRegistryEntry> findByServiceKey(ServiceKey serviceKey) {
        SpaceServiceRegistryEntry template = SpaceServiceRegistryEntry.template();
        template.setServiceKey(serviceKey);
        SpaceServiceRegistryEntry[] entries = (SpaceServiceRegistryEntry[])this.gigaSpace.readMultiple((Object)template);
        ArrayList<AstrixServiceRegistryEntry> result = new ArrayList<AstrixServiceRegistryEntry>(entries.length);
        for (SpaceServiceRegistryEntry spaceEntry : entries) {
            AstrixServiceRegistryEntry entry = new AstrixServiceRegistryEntry();
            entry.setServiceBeanType(spaceEntry.getApiType());
            entry.setServiceProperties(spaceEntry.getProperties());
            entry.setServiceMetadata(spaceEntry.getServiceMetadata());
            result.add(entry);
        }
        return result;
    }

    public void remove(ServiceProviderKey serviceProviderKey) {
        this.gigaSpace.takeById(SpaceServiceRegistryEntry.class, (Object)serviceProviderKey);
    }
}

