/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.test;

import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.beans.core.AstrixSettings;
import com.avanza.astrix.beans.registry.InMemoryServiceRegistry;
import com.avanza.astrix.config.ConfigSource;
import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.config.MapConfigSource;
import com.avanza.astrix.config.Setting;
import com.avanza.astrix.context.AstrixConfigurer;
import com.avanza.astrix.context.AstrixContext;
import com.avanza.astrix.core.ServiceUnavailableException;
import com.avanza.astrix.core.util.ReflectionUtil;
import com.avanza.astrix.test.TestApi;
import com.avanza.astrix.test.TestApis;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AstrixTestContext
implements AstrixContext {
    private final ProxiedServiceRegistry serviceRegistry;
    private final AstrixContext context;
    private final ConcurrentMap<AstrixBeanKey<?>, ProviderProxy<?>> providers = new ConcurrentHashMap();
    private final TestApis testApis;

    @Deprecated
    @SafeVarargs
    public AstrixTestContext(Class<? extends TestApi> ... testApis) {
        this(new MapConfigSource(), testApis);
    }

    @SafeVarargs
    public AstrixTestContext(MapConfigSource configSource, Class<? extends TestApi> ... testApis) {
        this.serviceRegistry = new ProxiedServiceRegistry(configSource);
        AstrixConfigurer configurer = new AstrixConfigurer();
        configurer.setConfig(DynamicConfig.create((ConfigSource)this.serviceRegistry, (ConfigSource[])new ConfigSource[0]));
        this.context = configurer.configure();
        this.testApis = new TestApis(this, testApis);
    }

    public String getConfigSourceId() {
        return this.serviceRegistry.getConfigSourceId();
    }

    public MapConfigSource getConfigSource() {
        return this.serviceRegistry.getConfigSource();
    }

    public String getServiceRegistryUri() {
        return this.serviceRegistry.getServiceUri();
    }

    public <T> T waitForBean(Class<T> type, long timeoutMillis) throws InterruptedException {
        return (T)this.context.waitForBean(type, timeoutMillis);
    }

    public <T> T waitForBean(Class<T> type, String qualifier, long timeoutMillis) throws InterruptedException {
        return (T)this.context.waitForBean(type, qualifier, timeoutMillis);
    }

    public <T> T getBean(Class<T> serviceBean) {
        return (T)this.context.getBean(serviceBean);
    }

    public <T> T getBean(Class<T> serviceBean, String qualifier) {
        return (T)this.context.getBean(serviceBean, qualifier);
    }

    public void destroy() {
        this.context.destroy();
    }

    public void close() throws Exception {
        this.context.close();
    }

    public <T> void registerProxy(Class<T> service) {
        this.setProxyState(service, null);
    }

    public <T> void registerProxy(Class<T> service, String qualifier) {
        this.setProxyState(service, qualifier, null);
    }

    <T> void set(Setting<T> setting, T value) {
        this.serviceRegistry.set(setting, value);
    }

    public <T> void setProxyState(Class<T> type, T mock) {
        ProviderProxy proxy = this.providers.computeIfAbsent(AstrixBeanKey.create(type), key -> {
            ProviderProxy<Object> providerProxy = new ProviderProxy<Object>(type, mock);
            this.serviceRegistry.registerProvider(type, providerProxy.newProxy());
            return providerProxy;
        });
        proxy.set(mock);
    }

    public <T> void setProxyState(Class<T> type, String qualifier, T mock) {
        ProviderProxy<T> proxy = this.getOrCreateProviderProxy(type, qualifier);
        proxy.set(mock);
    }

    private <T> ProviderProxy<T> getOrCreateProviderProxy(Class<T> type, String qualifier) {
        ProviderProxy proxy = this.providers.computeIfAbsent(AstrixBeanKey.create(type, (String)qualifier), key -> {
            ProviderProxy<Object> providerProxy = new ProviderProxy<Object>(type, null);
            this.serviceRegistry.registerProvider(type, qualifier, providerProxy.newProxy());
            return providerProxy;
        });
        return proxy;
    }

    public void resetProxies() {
        this.providers.values().forEach(providerProxy -> providerProxy.set(null));
    }

    public AstrixContext getAstrixContext() {
        return this.context;
    }

    public <T extends TestApi> T getTestApi(Class<T> testApi) {
        return this.testApis.getTestApi(testApi);
    }

    public void resetTestApis() {
        this.testApis.reset();
    }

    public void setConfigurationProperty(String settingName, String value) {
        this.serviceRegistry.set(settingName, value);
    }

    private static class ProxiedServiceRegistry
    extends InMemoryServiceRegistry {
        public ProxiedServiceRegistry(MapConfigSource configSource) {
            super(configSource);
            this.set(AstrixSettings.BEAN_BIND_ATTEMPT_INTERVAL, 100L);
            this.set(AstrixSettings.ENABLE_FAULT_TOLERANCE, false);
        }
    }

    private static class ProviderProxy<T>
    implements InvocationHandler {
        private volatile T target;
        private final Class<T> type;

        public ProviderProxy(Class<T> type, T target) {
            this.type = type;
            this.target = target;
        }

        public void set(T provider) {
            this.target = provider;
        }

        public T newProxy() {
            return (T)ReflectionUtil.newProxy(this.type, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            T target = this.target;
            if (target == null) {
                throw new ServiceUnavailableException("Proxy not bound to a type=" + this.type.getName() + ". Call AstrixRule.registerProvider to register a provider for the given bean");
            }
            return ReflectionUtil.invokeMethod((Method)method, target, (Object[])args);
        }
    }
}

