/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.test;

import com.avanza.astrix.beans.core.AstrixBeanKey;
import com.avanza.astrix.test.AstrixTestContext;
import com.avanza.astrix.test.TestApi;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

final class TestApis {
    private final AstrixTestContext astrixTestContext;
    private final List<Class<? extends TestApi>> testApis;
    private final ConcurrentMap<Class<? extends TestApi>, TestApi> testApiByType = new ConcurrentHashMap<Class<? extends TestApi>, TestApi>();
    private final Object testApiLock = new Object();
    private final Queue<AstrixBeanKey<?>> exportedServices = new ConcurrentLinkedQueue();

    @SafeVarargs
    public TestApis(AstrixTestContext astrixTestContext, Class<? extends TestApi> ... testApis) {
        this.astrixTestContext = astrixTestContext;
        this.testApis = Arrays.asList(testApis);
        this.testApis.forEach(this::ensureLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded(Class<? extends TestApi> testApi) {
        Object object = this.testApiLock;
        synchronized (object) {
            if (!this.testApiByType.containsKey(testApi)) {
                this.testApiByType.put(testApi, this.loadTestApi(testApi));
            }
        }
    }

    private TestApi loadTestApi(Class<? extends TestApi> testApiType) {
        TestApi testApi = this.initTestApi(testApiType);
        testApi.getTestApiDependencies().forEach(this::ensureLoaded);
        testApi.exportServices(new TestApiContext());
        return testApi;
    }

    private TestApi initTestApi(Class<? extends TestApi> testApiType) {
        try {
            return testApiType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate TestApi: " + testApiType.getName(), e);
        }
    }

    <T extends TestApi> T getTestApi(Class<T> testApi) {
        return (T)Optional.ofNullable((TestApi)this.testApiByType.get(testApi)).map(testApi::cast).orElseThrow(() -> new IllegalStateException("No TestApi registered for: " + testApi.getName()));
    }

    void reset() {
        this.exportedServices.forEach(key -> this.astrixTestContext.setProxyState(key.getBeanType(), key.getQualifier(), null));
        this.exportedServices.clear();
        this.testApiByType.clear();
        this.testApis.forEach(this::ensureLoaded);
    }

    private class TestApiContext
    implements TestApi.TestContext {
        private TestApiContext() {
        }

        @Override
        public <T> void registerService(Class<T> service, T serviceImpl) {
            this.registerService(service, null, serviceImpl);
        }

        @Override
        public <T> void registerService(Class<T> service, String qualifier, T serviceImpl) {
            TestApis.this.exportedServices.add(AstrixBeanKey.create(service, (String)qualifier));
            TestApis.this.astrixTestContext.setProxyState(service, qualifier, serviceImpl);
        }

        @Override
        public <T> T getBean(Class<T> serviceBean) {
            return TestApis.this.astrixTestContext.getBean(serviceBean);
        }

        @Override
        public <T> T getBean(Class<T> beanType, String qualifier) {
            return TestApis.this.astrixTestContext.getBean(beanType, qualifier);
        }

        @Override
        public <T extends TestApi> T getTestApi(Class<T> testApi) {
            return TestApis.this.getTestApi(testApi);
        }
    }
}

