/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.test;

import com.avanza.astrix.config.MapConfigSource;
import com.avanza.astrix.config.Setting;
import com.avanza.astrix.context.Astrix;
import com.avanza.astrix.context.AstrixContext;
import com.avanza.astrix.test.AstrixRuleContext;
import com.avanza.astrix.test.AstrixTestContext;
import com.avanza.astrix.test.TestApi;
import java.util.function.Consumer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstrixRule
implements TestRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AstrixTestContext astrixTestContext;

    @SafeVarargs
    public AstrixRule(Class<? extends TestApi> ... testApis) {
        this(new MapConfigSource(), testApis);
    }

    @SafeVarargs
    public AstrixRule(MapConfigSource configSource, Class<? extends TestApi> ... testApis) {
        this.astrixTestContext = new AstrixTestContext(configSource, (Class[])testApis);
    }

    @SafeVarargs
    public AstrixRule(Consumer<? super AstrixRuleContext> contextConfigurer, Class<? extends TestApi> ... testApis) {
        this(new MapConfigSource(), contextConfigurer, testApis);
    }

    @SafeVarargs
    public AstrixRule(MapConfigSource configSource, Consumer<? super AstrixRuleContext> contextConfigurer, Class<? extends TestApi> ... testApis) {
        this(configSource, testApis);
        contextConfigurer.accept((AstrixRuleContext)new AstrixRuleContext(){

            public <T> void registerProxy(Class<T> service) {
                AstrixRule.this.astrixTestContext.registerProxy(service);
            }

            public <T> void registerProxy(Class<T> service, String qualifier) {
                AstrixRule.this.astrixTestContext.registerProxy(service, qualifier);
            }

            public <T> void set(Setting<T> setting, T value) {
                AstrixRule.this.astrixTestContext.set(setting, value);
            }
        });
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        AstrixRule.this.astrixTestContext.destroy();
                    }
                    catch (Exception e) {
                        AstrixRule.this.log.warn("Error destroying AstrixTestContext", (Throwable)e);
                    }
                }
            }
        };
    }

    public String getConfigSourceId() {
        return this.astrixTestContext.getConfigSourceId();
    }

    public MapConfigSource getConfigSource() {
        return this.astrixTestContext.getConfigSource();
    }

    public String getServiceRegistryUri() {
        return this.astrixTestContext.getServiceRegistryUri();
    }

    public void destroy() {
        this.astrixTestContext.destroy();
    }

    public <T> void registerProxy(Class<T> service) {
        this.astrixTestContext.registerProxy(service);
    }

    public <T> void registerProxy(Class<T> service, String qualifier) {
        this.astrixTestContext.registerProxy(service, qualifier);
    }

    public <T> void setProxyState(Class<T> type, T mock) {
        this.astrixTestContext.setProxyState(type, mock);
    }

    public <T> void setProxyState(Class<T> type, String qualifier, T mock) {
        this.astrixTestContext.setProxyState(type, qualifier, mock);
    }

    public void resetProxies() {
        this.astrixTestContext.resetProxies();
    }

    public <T> T waitForBean(Class<T> type, long timeoutMillis) throws InterruptedException {
        return (T)this.astrixTestContext.waitForBean(type, timeoutMillis);
    }

    public <T> T waitForBean(Class<T> type, String qualifier, long timeoutMillis) throws InterruptedException {
        return (T)this.astrixTestContext.waitForBean(type, qualifier, timeoutMillis);
    }

    public Astrix getAstrix() {
        return this.astrixTestContext.getAstrixContext();
    }

    public AstrixContext getAstrixContext() {
        return this.astrixTestContext.getAstrixContext();
    }

    public <T extends TestApi> T getTestApi(Class<T> testApi) {
        return (T)this.astrixTestContext.getTestApi(testApi);
    }

    public void resetTestApis() {
        this.astrixTestContext.resetTestApis();
    }

    <T> T getBean(Class<T> serviceBean) {
        return (T)this.astrixTestContext.getBean(serviceBean);
    }

    <T> T getBean(Class<T> serviceBean, String qualifier) {
        return (T)this.astrixTestContext.getBean(serviceBean, qualifier);
    }

    public void setConfigurationProperty(String settingName, String value) {
        this.astrixTestContext.setConfigurationProperty(settingName, value);
    }
}

