/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.test;

import com.avanza.astrix.core.ServiceInvocationException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceInvocationExceptionTestBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Reflections reflections;

    protected ServiceInvocationExceptionTestBase(String packageName) {
        this.reflections = new Reflections(packageName, new Scanner[0]);
    }

    @Test
    public void exceptionsExtendsServiceInvocationException() {
        this.getSubTypesOf(RuntimeException.class).forEach(this::assertIsServiceInvocationException);
    }

    @Test
    public void subtypesOfServiceInvocationExceptionImplementRecreateOnClientSideMethod() throws Exception {
        Set<Class<ServiceInvocationException>> exceptions = this.getSubTypesOf(ServiceInvocationException.class);
        for (Class<ServiceInvocationException> exceptionClass : exceptions) {
            Method method = exceptionClass.getDeclaredMethod("recreateOnClientSide", new Class[0]);
            Class<?> declaringClass = method.getDeclaringClass();
            Assert.assertEquals((String)"Exception class must implement 'recreateOnClientSide' self.", declaringClass, exceptionClass);
        }
    }

    private <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        try {
            return this.reflections.getSubTypesOf(type);
        }
        catch (ReflectionsException exception) {
            this.log.trace("Could not retrieve subtypes of {}", type, (Object)exception);
            return Collections.emptySet();
        }
    }

    private void assertIsServiceInvocationException(Class<? extends RuntimeException> exceptionClass) {
        MatcherAssert.assertThat((Object)ServiceInvocationException.class.isAssignableFrom(exceptionClass), (Matcher)CoreMatchers.is((Object)true));
    }
}

