/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.test;

import com.avanza.astrix.config.MapConfigSource;
import com.avanza.astrix.context.Astrix;
import com.avanza.astrix.test.AstrixTest;
import com.avanza.astrix.test.AstrixTestContext;
import com.avanza.astrix.test.TestApi;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class AstrixExtension
implements ParameterResolver,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace ASTRIX_TEST_CONTEXT_NS = ExtensionContext.Namespace.create((Object[])new Object[]{AstrixExtension.class, AstrixTestContext.class});
    private final Function<ExtensionContext, Configuration> configurationFactory;

    private AstrixExtension(Function<ExtensionContext, Configuration> configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory);
    }

    AstrixExtension() {
        this(extensionContext -> AstrixExtension.findAnnotation(extensionContext, AstrixTest.class).map(annotation -> new Configuration(annotation.resetAfterEach(), annotation.value())).orElse(Configuration.DEFAULT));
    }

    @SafeVarargs
    public static AstrixExtension create(boolean resetAfterEach, Class<? extends TestApi> ... testApis) {
        return new AstrixExtension(extensionContext -> new Configuration(resetAfterEach, testApis));
    }

    @SafeVarargs
    public static AstrixExtension create(Class<? extends TestApi> ... testApis) {
        return AstrixExtension.create(true, testApis);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return Astrix.class.isAssignableFrom(parameterType) || TestApi.class.isAssignableFrom(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        AstrixTestContext astrixTestContext = this.getAstrixTestContext(extensionContext);
        if (AstrixTestContext.class.isAssignableFrom(parameterType)) {
            return astrixTestContext;
        }
        if (Astrix.class.isAssignableFrom(parameterType)) {
            return astrixTestContext.getAstrixContext();
        }
        if (TestApi.class.isAssignableFrom(parameterType)) {
            try {
                Class<?> testApiType = parameterType;
                return astrixTestContext.getTestApi(testApiType);
            }
            catch (RuntimeException exception) {
                throw new ParameterResolutionException("Cannot resolve parameter " + parameterType + " " + parameterContext.getParameter().getName(), (Throwable)exception);
            }
        }
        throw new ParameterResolutionException("Cannot resolve parameter " + parameterType + " " + parameterContext.getParameter().getName());
    }

    public void beforeAll(ExtensionContext context) {
        this.getAstrixTestContext(context);
    }

    public void afterEach(ExtensionContext context) {
        if (this.getConfiguration(context).isResetAfterEach()) {
            this.getAstrixTestContext(context).resetTestApis();
        }
    }

    public void afterAll(ExtensionContext context) {
        this.getAstrixTestContext(context).destroy();
    }

    public AstrixTestContext getAstrixTestContext(ExtensionContext context) {
        return (AstrixTestContext)AstrixExtension.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new AstrixTestContext(new MapConfigSource(), (Class[])this.getConfiguration(context).getTestApis()), AstrixTestContext.class);
    }

    private Configuration getConfiguration(ExtensionContext context) {
        return this.configurationFactory.apply(context);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(ASTRIX_TEST_CONTEXT_NS);
    }

    private static <T extends Annotation> Optional<T> findAnnotation(ExtensionContext context, Class<T> annotationType) {
        Optional annotation = AnnotationSupport.findAnnotation((Optional)context.getElement(), annotationType);
        if (annotation.isPresent()) {
            return annotation;
        }
        return context.getParent().flatMap(parent -> AstrixExtension.findAnnotation(parent, annotationType));
    }

    private static final class Configuration {
        private static final Configuration DEFAULT = new Configuration(true, new Class[0]);
        private final boolean resetAfterEach;
        private final Class<? extends TestApi>[] testApis;

        @SafeVarargs
        public Configuration(boolean resetAfterEach, Class<? extends TestApi> ... testApis) {
            this.resetAfterEach = resetAfterEach;
            this.testApis = testApis;
        }

        public boolean isResetAfterEach() {
            return this.resetAfterEach;
        }

        public Class<? extends TestApi>[] getTestApis() {
            return this.testApis;
        }
    }
}

