/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.PuRunner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openspaces.core.GigaSpace;
import org.springframework.context.ApplicationContext;

public class AsyncPuRunner
implements PuRunner {
    private final PuRunner puRunner;
    private volatile ExecutorService worker;

    public AsyncPuRunner(PuRunner puRunner) {
        this.puRunner = puRunner;
    }

    @Override
    public void run() throws Exception {
        this.worker = Executors.newSingleThreadExecutor();
        this.worker.execute(() -> {
            try {
                this.puRunner.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void shutdown() throws Exception {
        Future<Void> shutdownComplete = this.worker.submit(() -> {
            this.puRunner.shutdown();
            return null;
        });
        this.worker.shutdown();
        shutdownComplete.get();
    }

    @Override
    public String getLookupGroupName() {
        return this.puRunner.getLookupGroupName();
    }

    @Override
    public boolean autostart() {
        return this.puRunner.autostart();
    }

    @Override
    public GigaSpace getClusteredGigaSpace() {
        return this.get(() -> this.puRunner.getClusteredGigaSpace());
    }

    private <T> T get(Callable<T> callable) {
        try {
            return this.worker.submit(callable).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ApplicationContext getPrimaryInstanceApplicationContext(int partition) {
        return this.get(() -> this.puRunner.getPrimaryInstanceApplicationContext(partition));
    }

    @Override
    public int getNumInstances() {
        return this.puRunner.getNumInstances();
    }
}

