/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.JVMGlobalLus;
import java.util.UUID;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;

public class EmbeddedSpace
implements TestRule {
    private final UrlSpaceConfigurer urlSpaceConfigurer;
    private final GigaSpace gigaSpace;

    public EmbeddedSpace() {
        this("space-" + UUID.randomUUID().toString());
    }

    public EmbeddedSpace(String spaceName) {
        this.urlSpaceConfigurer = new UrlSpaceConfigurer("/./" + spaceName).lookupGroups(JVMGlobalLus.getLookupGroupName());
        this.gigaSpace = new GigaSpaceConfigurer(this.urlSpaceConfigurer.space()).gigaSpace();
    }

    public GigaSpace getGigaSpace() {
        return this.gigaSpace;
    }

    public void start() {
    }

    public void destroy() {
        this.urlSpaceConfigurer.close();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    EmbeddedSpace.this.start();
                    base.evaluate();
                }
                finally {
                    try {
                        EmbeddedSpace.this.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }
}

