/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GsNetworkOverride {
    private static final Logger LOG = Logger.getLogger(GsNetworkOverride.class.getName());
    private static final String MULTICAST_ADDRESS = "224.0.1.188";
    private static final int MULTICAST_PORT = 4174;
    private static final String RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";

    static void setSystemProperties() {
        if (System.getProperty(RMI_SERVER_HOSTNAME) != null) {
            return;
        }
        Optional<String> address = GsNetworkOverride.findAddressThatCanUseMulticast();
        if (!address.isPresent()) {
            LOG.log(Level.WARNING, "Could not reliably determine which network interface that supports multicast to 224.0.1.188 . You might experience problems running GigaSpaces integration tests. To resolve the issue, you might need to find which network interface to use for 224.0.1.188 by checking the matching line in the output from \"netstat -rn\" and then assigning this interface to -Djava.rmi.server.hostname .Flushing the routing table or restarting the computer might also work.");
        }
        String addr = address.orElse("localhost");
        LOG.log(Level.INFO, "Setting java.rmi.server.hostname=" + addr);
        System.setProperty(RMI_SERVER_HOSTNAME, addr);
    }

    private static Optional<String> findAddressThatCanUseMulticast() {
        try {
            for (NetworkInterface nic : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                LOG.log(Level.FINER, "Testing multicast on " + nic.getName());
                if (!GsNetworkOverride.supportsMulticast(nic)) continue;
                return GsNetworkOverride.getAddress(nic);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not enumerate network interfaces", e);
        }
        return Optional.empty();
    }

    private static Optional<String> getAddress(NetworkInterface nic) {
        String defaultAddress = null;
        for (InetAddress addr : Collections.list(nic.getInetAddresses())) {
            String s = addr.getHostAddress();
            if (GsNetworkOverride.looksLikeIpv4Address(s)) {
                return Optional.of(s);
            }
            defaultAddress = s;
        }
        return Optional.ofNullable(defaultAddress);
    }

    private static boolean looksLikeIpv4Address(String s) {
        return s.contains(".");
    }

    private static boolean supportsMulticast(NetworkInterface nic) {
        try {
            if (!nic.isUp()) {
                return false;
            }
            if (!nic.supportsMulticast()) {
                return false;
            }
            GsNetworkOverride.testMulticastOnInterface(nic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void testMulticastOnInterface(NetworkInterface nic) throws IOException {
        int port = 4174;
        int timeout = (int)Duration.ofMillis(10L).toMillis();
        InetAddress multicastAddress = InetAddress.getByName(MULTICAST_ADDRESS);
        try (MulticastSocket receiveSocket = new MulticastSocket(4174);
             MulticastSocket sendSocket = new MulticastSocket(4175);){
            receiveSocket.setNetworkInterface(nic);
            receiveSocket.setSoTimeout(timeout);
            receiveSocket.joinGroup(multicastAddress);
            sendSocket.setNetworkInterface(nic);
            sendSocket.setSoTimeout(timeout);
            sendSocket.setTimeToLive(0);
            byte[] sendBuf = new byte[20];
            sendSocket.send(new DatagramPacket(sendBuf, sendBuf.length, multicastAddress, 4174));
            byte[] rcvBuf = new byte[20];
            receiveSocket.receive(new DatagramPacket(rcvBuf, rcvBuf.length));
        }
    }
}

