/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.MirrorPuConfigurer;
import com.avanza.gs.test.PuRunner;
import java.io.IOException;
import java.util.Properties;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainer;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainerProvider;
import org.springframework.context.ApplicationContext;

public class MirrorPu
implements PuRunner {
    private IntegratedProcessingUnitContainer container;
    private final String gigaSpaceBeanName = "gigaSpace";
    private final String puXmlPath;
    private Properties contextProperties = new Properties();
    private final String lookupGroupName;
    private final boolean autostart;
    private final ApplicationContext parentContext;

    public MirrorPu(MirrorPuConfigurer config) {
        this.puXmlPath = config.puXmlPath;
        this.contextProperties = config.properties;
        this.lookupGroupName = config.lookupGroupName;
        this.autostart = true;
        this.parentContext = config.parentContext;
        this.contextProperties.put("gs.space.url.arg.timeout", "10");
        this.contextProperties.put("gs.space.url.arg.groups", this.lookupGroupName);
    }

    @Override
    public void run() throws IOException {
        try {
            this.startContainers();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start containers for puXmlPath: " + this.puXmlPath, e);
        }
    }

    private void startContainers() throws IOException {
        IntegratedProcessingUnitContainerProvider provider = new IntegratedProcessingUnitContainerProvider();
        provider.setBeanLevelProperties(this.createBeanLevelProperties());
        provider.addConfigLocation(this.puXmlPath);
        if (this.parentContext != null) {
            provider.setParentContext(this.parentContext);
        }
        this.container = (IntegratedProcessingUnitContainer)provider.createContainer();
    }

    private BeanLevelProperties createBeanLevelProperties() {
        BeanLevelProperties beanLevelProperties = new BeanLevelProperties();
        beanLevelProperties.setContextProperties(this.contextProperties);
        return beanLevelProperties;
    }

    @Override
    public void shutdown() {
        this.container.close();
    }

    @Override
    public String getLookupGroupName() {
        return this.lookupGroupName;
    }

    @Override
    public boolean autostart() {
        return this.autostart;
    }

    @Override
    public GigaSpace getClusteredGigaSpace() {
        return ((GigaSpace)GigaSpace.class.cast(this.container.getApplicationContext().getBean(this.gigaSpaceBeanName))).getClustered();
    }

    @Override
    public ApplicationContext getPrimaryInstanceApplicationContext(int partition) {
        return this.container.getApplicationContext();
    }

    @Override
    public int getNumInstances() {
        return 1;
    }
}

