/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.PartitionedPuConfigurer;
import com.avanza.gs.test.PuRunner;
import com.avanza.gs.test.SecurityManagerForTests;
import com.avanza.gs.test.UniqueSpaceNameLookup;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainer;
import org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainerProvider;
import org.openspaces.pu.container.support.CompoundProcessingUnitContainer;
import org.springframework.context.ApplicationContext;

public final class PartitionedPu
implements PuRunner {
    private CompoundProcessingUnitContainer container;
    private final String gigaSpaceBeanName = "gigaSpace";
    private final String puXmlPath;
    private final Integer numberOfPrimaries;
    private final Integer numberOfBackups;
    private final Properties contextProperties = new Properties();
    private final Map<String, Properties> beanProperies = new HashMap<String, Properties>();
    private final String lookupGroupName;
    private final boolean autostart;
    private final ApplicationContext parentContext;
    private final boolean useAuthentication;

    public PartitionedPu(PartitionedPuConfigurer configurer) {
        this.puXmlPath = configurer.puXmlPath;
        this.numberOfBackups = configurer.numberOfBackups;
        this.numberOfPrimaries = configurer.numberOfPrimaries;
        this.contextProperties.putAll((Map<?, ?>)configurer.contextProperties);
        this.beanProperies.putAll(configurer.beanProperies);
        this.lookupGroupName = configurer.lookupGroupName;
        this.autostart = configurer.autostart;
        this.parentContext = configurer.parentContext;
        this.useAuthentication = configurer.useAuthentication;
        this.contextProperties.put("spaceName", UniqueSpaceNameLookup.getSpaceNameWithSequence(configurer.spaceName));
        this.contextProperties.put("gs.space.url.arg.groups", this.lookupGroupName);
        this.contextProperties.put("gs.space.url.arg.timeout", "10");
    }

    @Override
    public void run() throws IOException {
        try {
            this.startContainers();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start containers for puXmlPath: " + this.puXmlPath, e);
        }
    }

    private void startContainers() throws IOException {
        IntegratedProcessingUnitContainerProvider provider = new IntegratedProcessingUnitContainerProvider();
        provider.setBeanLevelProperties(this.createBeanLevelProperties());
        provider.setClusterInfo(this.createClusterInfo());
        provider.addConfigLocation(this.puXmlPath);
        if (this.parentContext != null) {
            provider.setParentContext(this.parentContext);
        }
        if (this.useAuthentication) {
            this.enableAuthentication(provider);
        }
        this.container = (CompoundProcessingUnitContainer)provider.createContainer();
    }

    private void enableAuthentication(IntegratedProcessingUnitContainerProvider provider) {
        Properties contextProperties = provider.getBeanLevelProperties().getContextProperties();
        contextProperties.put("com.gs.security.security-manager.class", new SecurityManagerForTests());
        DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider("testuser", "testpass");
        provider.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        System.getProperties().put("com.gs.security.credentials-provider.class", credentialsProvider);
        contextProperties.setProperty("space-config.proxy.router.active-server-lookup-timeout", "300");
        contextProperties.setProperty("cluster-config.groups.group.fail-over-policy.active-election.yield-time", "100");
    }

    private ClusterInfo createClusterInfo() {
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setSchema("partitioned-sync2backup");
        clusterInfo.setNumberOfInstances(this.numberOfPrimaries);
        clusterInfo.setNumberOfBackups(this.numberOfBackups);
        clusterInfo.setInstanceId(null);
        return clusterInfo;
    }

    private BeanLevelProperties createBeanLevelProperties() {
        BeanLevelProperties beanLevelProperties = new BeanLevelProperties();
        beanLevelProperties.setContextProperties(this.contextProperties);
        for (Map.Entry<String, Properties> beanProperties : this.beanProperies.entrySet()) {
            beanLevelProperties.setBeanProperties(beanProperties.getKey(), beanProperties.getValue());
        }
        return beanLevelProperties;
    }

    @Override
    public void shutdown() {
        this.container.close();
    }

    @Override
    public String getLookupGroupName() {
        return this.lookupGroupName;
    }

    @Override
    public boolean autostart() {
        return this.autostart;
    }

    @Override
    public GigaSpace getClusteredGigaSpace() {
        return ((GigaSpace)GigaSpace.class.cast(this.getPrimaryInstanceApplicationContext(0).getBean(this.gigaSpaceBeanName))).getClustered();
    }

    @Override
    public ApplicationContext getPrimaryInstanceApplicationContext(int partition) {
        IntegratedProcessingUnitContainer container = (IntegratedProcessingUnitContainer)this.container.getProcessingUnitContainers()[partition];
        return container.getApplicationContext();
    }

    @Override
    public int getNumInstances() {
        return this.numberOfPrimaries;
    }
}

